package com.peak.framework.util;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
/**
 * @功能描述: 保存beanFactory 对象
 *           这个类提供了spring 本身的自省功能,把应用程序中不受spring管理的类和受spring管理的类联系起来.
 *           本类应该被配置为单列
 *           配置设置:
 *            <bean  class="com.peak.framework.util.SpringContainer"  factory-method="getSpringContainer"/>
 * @author 赵国栋
 * @version 1.0 2008-8-25       
 */
public class SpringContainer implements  BeanFactoryAware,ApplicationContextAware{
	    private    static  SpringContainer self=new SpringContainer();
	    private    BeanFactory beanfactory;
	    private    ApplicationContext application;
	    private    SpringContainer(){}
	    public static  boolean isEmpty(){
		       return  self.beanfactory==null?true:false;
		}
	    public static SpringContainer getSpringContainer(){
	    	    return self;
	    }
	    public static Object getObject(String str)
	    {       
	            return self.beanfactory.getBean(str);
	    }
		public void setBeanFactory(BeanFactory beanfactory) throws BeansException {
			  if( this.beanfactory==null)
				  this.beanfactory=beanfactory;
		}
		public void setApplicationContext(ApplicationContext application)  throws BeansException {
		      if(this.application==null)
		    	  this.application=application;
		}
}