package com.peak.prd.base.advise;

import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import com.peak.common.util.DataAuthUtil;
import com.peak.common.util.SpringUtil;
import com.peak.prd.base.annotation.DataAuth;
import com.peak.prd.base.annotation.DomainAuth;
import com.peak.prd.base.controller.PrdBaseController;
import com.peak.prd.base.service.IDataAuthService;
import com.peak.prd.base.service.IDomainAuthService;
import com.peak.prd.base.service.imple.NullDataAuthService;
import com.peak.prd.exception.DataAuthException;

/**
 * 数据鉴权拦截器
 * @author zhangdexin
 *
 */
@Aspect
@Component
public class DataAuthAdvise {
	/**
	 * 在管理端（mng/**）controller方法执行前拦截
	 * @param joinPoint
	 */
	@Before(value="execution(* com.peak.mng..controller.*.*(..))")
	public void beforeMngControllerMethod(JoinPoint joinPoint) {
		MethodSignature ms = (MethodSignature) joinPoint.getSignature();
		
		DomainAuth domainAuth = ms.getMethod().getAnnotation(DomainAuth.class);
		DataAuth[] das = ms.getMethod().getAnnotationsByType(DataAuth.class);
		if ((das == null || das.length == 0) && domainAuth == null) {
			return; // 无需鉴权：如果方法上没有DataAuth/DomainAuth注解
		}

		DefaultParameterNameDiscoverer defaultParameterNameDiscoverer = new DefaultParameterNameDiscoverer();
		String[] parameterNames = defaultParameterNameDiscoverer.getParameterNames(ms.getMethod());

		// 填充表达式上下文环境
		StandardEvaluationContext ctx = new StandardEvaluationContext();
		for (int j = 0; j < parameterNames.length; j++) {
			ctx.setVariable(parameterNames[j], joinPoint.getArgs()[j]);
		}
		
		// 当前用户id、当前管理域id
		PrdBaseController controller = (PrdBaseController)joinPoint.getThis();
		HttpServletRequest request = controller.getRequest();
		Long currUserId = controller.getUserIdOfNullable(request);
		Long currMngDomainId = controller.getMngDomainId(request);
		
		if (domainAuth != null) {
			String spel = domainAuth.id(); // SpEL 业务id
			ExpressionParser parser = new SpelExpressionParser();
			Expression expression = parser.parseExpression(spel);

			// 计算SpEl 得到 业务id
			Long domainIdToCheck = expression.getValue(ctx, Long.class); 
			
			if (domainIdToCheck != null) {
				IDomainAuthService domainAuthService = SpringUtil.getBean(IDomainAuthService.class);
				if (!domainAuthService.domainAuth(domainIdToCheck, currUserId, currMngDomainId)) {
					throw new DataAuthException("数据域访问越权[currUserId:" + currUserId + "][want:" + domainIdToCheck + "][curr:" + currMngDomainId + "]");
				}
			}
			
			return; // domainAuth 和 dataAuth 不同时使用
		}

		// 循环多个DataAuth注解
		Object[] bizObjArray = new Object[das.length];
		for (int i = 0; i < das.length; i++) {
			Long idVal = null;
			List<Long> idsVal = null;
			String spel = das[i].id(); // SpEL 业务id
			String multiSpel = das[i].ids(); // 多id
			if (StringUtils.isEmpty(spel) && StringUtils.isEmpty(multiSpel)) {
				// 没有显式的指定id，则尝试获取id
				Object[] args = joinPoint.getArgs();
				int longIdx = -1;
				int longCnt = 0;
				for (int j=0; j<args.length; j++) {
					if (args[j] instanceof Long) {
						longCnt += 1;
						longIdx = j;
					}
				}
				
				// 如果有且仅有1个Long类型方法参数
				if (longCnt == 1) {
					idVal = (Long)args[longIdx];
				}
			}
			else if (!StringUtils.isEmpty(spel)) {
				// 显式的指定了SpEL格式的业务id表达式
				ExpressionParser parser = new SpelExpressionParser();
				Expression expression = parser.parseExpression(spel);
	
				// 计算SpEl 得到 业务id
				idVal = expression.getValue(ctx, Long.class); 
			}
			else {
				// 多id
				ExpressionParser parser = new SpelExpressionParser();
				Expression expression = parser.parseExpression(multiSpel);
	
				// 计算SpEl 得到 业务ids
				idsVal = expression.getValue(ctx, List.class); 
			}

			Class<? extends IDataAuthService> service = das[i].service();
			IDataAuthService dataAuthService = SpringUtil.getBean(service);
			
			if (dataAuthService instanceof NullDataAuthService) {
				// 如果在方法上 未指定 service，则去寻找类注解
				DataAuth[] controllerDataAuth = controller.getClass().getAnnotationsByType(DataAuth.class);
				if (controllerDataAuth != null && controllerDataAuth.length > 0) {
					service = controllerDataAuth[0].service();
					dataAuthService = SpringUtil.getBean(service);
				}
			}

			// 业务数据鉴权
			if (!CollectionUtils.isEmpty(idsVal)) {
				// 多id
				Object bizObj = dataAuthService.dataAuth(idsVal, currUserId, currMngDomainId); 
				bizObjArray[i] = bizObj;
			}
			else {
				// 单id
				Object bizObj = dataAuthService.dataAuth(idVal, currUserId, currMngDomainId); 
				bizObjArray[i] = bizObj;
			}
		} // 循环结束
		
		request.setAttribute(DataAuthUtil.AUTHED_DATA, bizObjArray);
	}
}
