package com.peak.prd.base.advise;

import com.peak.prd.base.annotation.LessonPath;
import com.peak.prd.base.annotation.LessonPaths;
import com.peak.prd.base.annotation.ResPath;
import com.peak.prd.base.annotation.ResPaths;
import com.peak.prd.base.model.ApiResult;
import com.peak.prd.base.service.IBasePathService;
import com.peak.prd.base.util.ResPathUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

import javax.servlet.http.HttpServletRequest;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

@ControllerAdvice
public class ResPathHandler implements ResponseBodyAdvice {
	@Autowired
	IBasePathService basePathService;

	@Override
	public boolean supports(MethodParameter returnType, Class converterType) {
		Method method = returnType.getMethod();
		boolean b = method.isAnnotationPresent(ResPath.class)
				|| method.isAnnotationPresent(ResPaths.class)
				|| method.isAnnotationPresent(LessonPath.class)
				|| method.isAnnotationPresent(LessonPaths.class);

		return b;
	}

	@Override
	public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType,
			Class selectedConverterType, ServerHttpRequest req, ServerHttpResponse res) {
//		String basePath = basePathService.getPicBasePath(request.getURI()); 
//		long beginMs = System.currentTimeMillis();
		Method method = returnType.getMethod();
		Annotation[] allAnnos = method.getAnnotations();
//		List<Item> itemList = new ArrayList<Item>();		
//		for (Annotation a : allAnnos) {
//			if (a instanceof ResPaths) {
//				ResPaths rps = (ResPaths)a;
//				for (ResPath r : rps.value()) {
//					itemList.add(new Item(r));
//				}
//			}
//			else if (a instanceof ResPath) {
//				itemList.add(new Item((ResPath)a));
//			}
//			else if (a instanceof LessonPaths) {
//				LessonPaths rps = (LessonPaths)a;
//				for (LessonPath r : rps.value()) {
//					itemList.add(new Item(r));
//				}
//			}
//			else if (a instanceof LessonPath) {
//				itemList.add(new Item((LessonPath)a));
//			}
//		}
//		记录非课程
		List<Item> resPathList = new ArrayList<Item>();
//		课程，区分是因为课程可会会使用单独的域名
		List<Item> lessonPathList = new ArrayList<Item>();
		for (Annotation a : allAnnos) {
			if (a instanceof ResPaths) {
				ResPaths rps = (ResPaths)a;
				for (ResPath r : rps.value()) {
					resPathList.add(new Item(r));
				}
			}
			else if (a instanceof ResPath) {
				resPathList.add(new Item((ResPath)a));
			}
			else if (a instanceof LessonPaths) {
				LessonPaths rps = (LessonPaths)a;
				for (LessonPath r : rps.value()) {
					lessonPathList.add(new Item(r));
				}
			}
			else if (a instanceof LessonPath) {
				lessonPathList.add(new Item((LessonPath)a));
			}
		}
		
		Object data = null;
		boolean isErrorStatus = false;
		if (body instanceof ApiResult) {
			ApiResult ar = (ApiResult)body;
			isErrorStatus = ar.getStatus() != ApiResult.STATUS_OK;
			data = ar.getData();
		}
		else {
			data = body;
		}
		
		// 循环1~n个respath注解
//		for (Item item : itemList) {
//			String[] fields = item.fields;
//			if (fields == null || fields.length == 0) {
//				fields = new String[] { item.value };
//			}
//
//			for (int i=0; i<fields.length; i++) {
//				String picFieldName = fields[i];
//				String prefixPath = basePath + item.prefix;
//				try {
//					data = ResPathUtil.prependPath(data, picFieldName, prefixPath);
//				}
//				catch (Exception ex) {
//					ex.printStackTrace();
//				}
//			}
//			
//		} // end of loop annoArray
		
		if (!isErrorStatus) {
			HttpServletRequest request = ((ServletRequestAttributes) (RequestContextHolder.currentRequestAttributes())).getRequest();
			String basePath = basePathService.getPicBasePath(request); 
			addBathPath(basePath, resPathList, data, false);
			basePath = basePathService.getLessonBasePath(request); 
			addBathPath(basePath, lessonPathList, data,true);
		}
		

		return body;
	}
	/**
	 * 给data中文件路径添加basepath
	 * @param basePath 
	 * @param itemList 需要添加的项
	 * @param data
	 * @param islessonpath 是否课程路径，课程路径http全路径时，不进行处理，其他都需要截取掉
	 * @author wzy
	 * @CreateDate 2021年11月5日
	 *
	 */
	private void addBathPath(String basePath, List<Item> itemList, Object data, boolean islessonpath) {
		for (Item item : itemList) {
			String[] fields = item.fields;
			if (fields == null || fields.length == 0) {
				fields = new String[] { item.value };
			}

			for (int i=0; i<fields.length; i++) {
				String picFieldName = fields[i];
				String prefixPath = basePath + item.prefix;
				try {
					data = ResPathUtil.prependPath(data, picFieldName, prefixPath,islessonpath);
				}
				catch (Exception ex) {
					ex.printStackTrace();
				}
			}
			
		}
	}
	
	class Item {
		public Item(ResPath r) {
			this.value = r.value();
			this.fields = r.fields();
			this.prefix = r.prefix();
		}
		
		public Item(LessonPath r) {
			this.value = r.value();
			this.fields = r.fields();
			this.prefix = r.prefix();
			this.category = "lesson";
		}
		
		String[] fields;
		String value;
		String prefix;
		String category;
	}

}
