package com.peak.prd.base.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * @author ZhengJia
 * @version 1.0
 * @date 2023/11/8 2:30 PM
 */
@Target({ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
public @interface ClearCache {

    /**
     * @description id参数名称，可以使用Spel表达式，不能为空
     * @author ZhegnJia
     * @date 2023/11/9 9:52 AM
     **/
    String value() default "";
    
    /**
     * @description 参数列表，可以使用Spel表达式
     * @return
     * @author ZhengJia
     * @date 2025/1/13 17:07
     **/
    String[] values() default {};
    
    /**
     * 多个参数时使用，可以使用Spel表达式
     */
    String[] keys() default {};

}
