package com.peak.prd.base.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import com.peak.prd.base.service.IDataAuthService;
import com.peak.prd.base.service.imple.NullDataAuthService;

/**
 * 数据鉴权注解 - 作用于方法上，可以有多个DataAuth注解 
 * @author zhangdexin
 *
 */
@Target({ElementType.TYPE, ElementType.METHOD}) 
@Retention(RetentionPolicy.RUNTIME) // 运行时有效
@Repeatable(DataAuths.class)
@Inherited
public @interface DataAuth {
	/**
	 * 实现了IDataAuthService接口的service.class
	 * @return
	 */
	Class<? extends IDataAuthService> service() default NullDataAuthService.class;
	
	/**
	 * SpEL 传递单个实体id进来
	 * @return
	 */
	String id() default "";
	
	/**
	 * SpEL 传递多个实体id进来(List<Long>)
	 * @return
	 */
	String ids() default "";
}
