package com.peak.prd.base.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * 数据鉴权注解 - 作用于方法上
 * @author zhangdexin
 *
 */
@Target({ElementType.TYPE, ElementType.METHOD}) 
@Retention(RetentionPolicy.RUNTIME) // 运行时有效
@Inherited
public @interface DomainAuth {
	/**
	 * SpEL 传域id进来  （可以是空值，空值不越权，由业务方法自己处理空值情况）
	 * @return
	 */
	String id() default "";
}
