package com.peak.prd.base.controller;

import com.peak.prd.enums.GatewayHeaderEnum;
import com.peak.prd.exception.SessionNullException;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

/**
 * 业务controller的基类
 * @author zhangdexin
 */
public abstract class PrdBaseController  {
	
	private static String GATEWAY_HEADER_ISMOBILE = GatewayHeaderEnum.GATEWAY_HEADER_ISMOBILE.getValue();
	private static String GATEWAY_HEADER_USERID = GatewayHeaderEnum.GATEWAY_HEADER_USERID.getValue();
	private static String GATEWAY_HEADER_USERNAME = GatewayHeaderEnum.GATEWAY_HEADER_USERNAME.getValue();
	private static String GATEWAY_HEADER_MNGDOMAINID = GatewayHeaderEnum.GATEWAY_HEADER_MNGDOMAINID.getValue();
	
	/**
	 * 是否是移动端请求---来自网关
	 */
	public boolean isMobile(HttpServletRequest request) {
		return "true".equals(request.getHeader(GATEWAY_HEADER_ISMOBILE));
	}
	
	/**
	 * 当前用户-登录名，如果为null会抛异常，并被拦截器自动处理 ---来自网关
	 */
	public String getUsername(HttpServletRequest request) {
		String username = request.getAttribute(GATEWAY_HEADER_USERNAME) != null ? (String)request.getAttribute(GATEWAY_HEADER_USERNAME) : request.getHeader(GATEWAY_HEADER_USERNAME);
		if (username != null && !username.isEmpty()) return username;
		
		throw new SessionNullException();
	}
	
	/**
	 * 当前用户-登录名，可能为null---来自网关
	 */
	public String getUsernameOfNullable(HttpServletRequest request) {
		return request.getAttribute(GATEWAY_HEADER_USERNAME) != null ? (String)request.getAttribute(GATEWAY_HEADER_USERNAME) : request.getHeader(GATEWAY_HEADER_USERNAME);
	}
	
	/**
	 * 当前用户-id，如果为null会抛异常，并被拦截器自动处理---来自网关 <br />
	 * 开发的时候，自己改下代码，先写死1个值
	 */
	public Long getUserId(HttpServletRequest request) {
		String sid = request.getAttribute(GATEWAY_HEADER_USERID) != null ? (String)request.getAttribute(GATEWAY_HEADER_USERID) : request.getHeader(GATEWAY_HEADER_USERID);
		if (sid != null && !sid.isEmpty()) {
			return Long.valueOf(sid);
		}
		
		throw new SessionNullException();
	}
	
	/**
	 * 当前用户-id，可能为null---来自网关 <br />
	 * 开发的时候，自己改下代码，先写死1个值
	 */
	public Long getUserIdOfNullable(HttpServletRequest request) {
		String sid = request.getAttribute(GATEWAY_HEADER_USERID) != null ? (String)request.getAttribute(GATEWAY_HEADER_USERID) : request.getHeader(GATEWAY_HEADER_USERID);
		if (sid != null && !sid.isEmpty()) {
			return new Long(sid);
		}
		
		return null;
	}
	
	/**
	 * 当前管理域id（可能为null）---来自网关<br />
	 * 仅对mng/*请求有效
	 */
	public Long getMngDomainId(HttpServletRequest request) {
		String str = request.getAttribute(GATEWAY_HEADER_MNGDOMAINID) != null ? (String)request.getAttribute(GATEWAY_HEADER_MNGDOMAINID) : request.getHeader(GATEWAY_HEADER_MNGDOMAINID);
		if (str != null && !str.isEmpty()) {
			return new Long(str);
		}
		
		return null;
	}
	
//	public static final String prefixPathMobile = "/swp/prd/"; 
//	public static final String prefixPathPC     = "/prd/"; 
//	public static final String suffix = ".action";
	
//	@Autowired
//	private HttpServletRequest request;
//	 
//	@Autowired
//	private HttpServletResponse response;
//	
//	public HttpServletResponse getResponse() {
//		return this.response;
//	}
	
//	protected String outJson(boolean isSuccess, String msg, Map<String, Object> map) {
//		JSONObject jObj = new JSONObject();
//		jObj.put("success", isSuccess ? 1 : 0);
//		jObj.put("msg", msg);
//		if (map != null) {
//			Iterator<String> iter = map.keySet().iterator();
//			while (iter.hasNext()) {
//				String k = iter.next();
//				jObj.put(k, map.get(k));
//			}
//		}
//		return jObj.toString();
//	}
	
//	protected Long assertGetUserID() {
//		Long uid = this.getUserID();
//		if (uid == null) {
//			throw new SessionNullException();
//		}
//		return uid;
//	}
//	
//	protected void assertFileExt(MultipartFile[] files) {
//		for (int i=0; files!=null && i<files.length; i++) {
//			this.assertFileExt(files[i]);
//		}
//	}
//	
//	protected void assertFileExt(MultipartFile file) {
//		String[] whiteList = new String[] {".jpg", ".gif"};
//		for (String white : whiteList) {
//			if (file.getOriginalFilename().endsWith(white)) {
//				return;
//			}
//		}
//		throw new FileExtException();
//	}
	
//	protected ApiResult error(String code, String msg) {
//		ApiResult ar = new ApiResult();
//		ar.setStatus(ApiResult.STATUS_ERR);
//		ar.setCode(code);
//		ar.setMsg(msg);
//		return ar;
//	}
//	
//	protected ApiResult success(Object data) {
//		ApiResult ar = new ApiResult();
//		ar.setStatus(ApiResult.STATUS_OK);
//		ar.setData(data);
//		return ar;
//	}
//
//	protected ApiResult success(String code, String msg) {
//		ApiResult ar = new ApiResult();
//		ar.setStatus(ApiResult.STATUS_OK);
//		ar.setCode(code);
//		ar.setMsg(msg);
//		return ar;
//	}
	
	/**
	 * 返回当前http请求对象
	 */
	public HttpServletRequest getRequest() {
		return ((ServletRequestAttributes) (RequestContextHolder.currentRequestAttributes())).getRequest();
	}
	
//	/**
//	 * 是否是移动端请求
//	 */
//	public boolean isMobile(HttpServletRequest request) {
//		String uri = request.getRequestURI();
//		return uri.indexOf("/swp/") >= 0;
//	}
	
//	/**
//	 * 获取当前登录用户的Id（可能返回null）
//	 */
//	protected Long getUserID() {
//		HttpServletRequest request = ((ServletRequestAttributes) (RequestContextHolder.currentRequestAttributes()))
//				.getRequest();
//		UserInfo ui = this.getUserInfo(request);
//		if (ui == null)
//			return null;
//		return ui.getUserId();
//	}
//
//	public UserInfo getUserInfo(HttpServletRequest request) {
////		SessionUser su = AppSysContext.getSessionUser(request);
//		UserInfo ui = new UserInfo();
//		ui.setUserId(99L);
////		ui.setUsername(su.getUsername());
//		return ui;
//	}
	
//	public String getParam(String name) {
//		HttpServletRequest request = ((ServletRequestAttributes) (RequestContextHolder.currentRequestAttributes()))
//				.getRequest();
//		return request.getParameter(name);
//	}

//	public Long getParamL(String paramName) {
//		HttpServletRequest request = ((ServletRequestAttributes) (RequestContextHolder.currentRequestAttributes()))
//				.getRequest();
//		String paramV = request.getParameter(paramName);
//		if ((paramV == null) || ("".equals(paramV.trim()))) {
//			return null;
//		}
//		return Long.valueOf(paramV);
//	}
//	
//	public Integer getParamInt(String paramName) {
//		return getParamInt(paramName, null);
//	}
//
//	public Integer getParamInt(String paramName, Integer defaultValue) {
//		HttpServletRequest request = ((ServletRequestAttributes) (RequestContextHolder.currentRequestAttributes()))
//				.getRequest();
//		String paramV = request.getParameter(paramName);
//		if ((paramV == null) || ("".equals(paramV.trim()))) {
//			return defaultValue;
//		}
//		return Integer.valueOf(paramV);
//	}
	  
	  // 会引起filter异常（getOutputStream已经...�?
//	  public void outJson(Object o) throws UnsupportedEncodingException, IOException {
//		  String str = null;
//		  if (o instanceof JSONObject || o instanceof JSONArray) {
//			  str = o.toString();
//		  }
//		  else if (o instanceof java.util.List) {
//			  str = JSONArray.fromObject(o).toString();
//		  }
//		  else {
//			  str = JSONObject.fromObject(o).toString();
//		  }
//		  response.setContentType("application/x-json;charset=UTF-8");
//		  response.getOutputStream().write(str.getBytes("UTF-8"));
//		  response.getOutputStream().flush();
//	  }
}
