package com.peak.prd.base.dao;

import com.peak.framework.common.BaseEntity;
import com.peak.framework.common.IEntityDao;
import com.peak.framework.common.page.IQuery;
import com.peak.prd.base.model.Paging;

import java.util.List;

/**
 * 业务DAO的基类，DAO层操作不可以用cache
 * @author zhangdexin
 */
public interface IPrdBaseDao<E extends BaseEntity,PK,V extends IQuery<E>> extends IEntityDao<E,PK,V> {
	/** findAll的分页版本, sqlId=findAll */
	public List<E> findList(V query);
	
	/** findAll的分页版本，手工指定sqlId */
	public List<E> findList(V query, String sqlId);
	
	/** findAll的分页版本，手工指定sqlId和mapper的resultMap对应类型 */
	public <T> List<T> findList(V query, String sqlId, Class<T> clazz) ;
	
	/** findList(pageSize=1) */
	public E findOne(V query);
	
	/** selectOne */
	public Object selectOne(V query, String sqlId);
	
	/** getByIds */
	public List<E> getByIds(List<PK> ids);
	
	/** count，手工指定sqlId */
	public long count(V query, String sqlId);
	/**
	 * 获得符合条件最多5000数据，限制5000条是为了防止使用错误导致内存溢出发生
	 * @param query query参数
	 * @param sqlId mapper中的sqlId
	 * @return java.util.List<E>
	 * @author wzy
	 * @date 2022/8/22 17:47
	 * @Deprecated 2024-11-2起不再推荐使用，推荐使用findList
	 */
	@Deprecated
	List<E> findAll(V query, String sqlId);


	/** 
	 * 按照翻页进行查询，并转换为对应的类
	 * @param query 查询条件，属性为null或‘’,不包含此条件
	 * @param clazz 需要转换的类
     * @return com.peak.prd.base.model.Paging<VO> 翻页的VO
	 * @author wzy
	 * @date 2022/8/25 16:16
	 */
	<VO> Paging<VO> findPaging(V query, Class<VO> clazz);

	/** 
	 * 按照翻页进行查询，使用时需要在mapper中编写查询和count两个sql，且count的id命名必须为查询Id+".count"
	 * @param query 查询条件，属性为null或‘’,不包含此条件
	 * @param sqlId 指定的sqlId，不包含namespace
	 * @param clazz  需要转换的类
	 * @return 翻页的VO
	 * @author wzy
	 * @date 2022/9/30 17:34
	 */
    <VO> Paging<VO> findPaging(V query, String sqlId, Class<VO> clazz);

    /**
	 * 按照翻页进行查询
	 * @param query 查询条件，属性为null或‘’,不包含此条件
	 * @return 翻页对象
	 * @author wzy
	 * @date 2022/8/25 14:28
	 */
	Paging<E> findPaging(V query);

	/**
	 * 按照翻页进行查询，使用时需要在mapper中编写查询和count两个sql，且count的id命名必须为查询Id+".count"
	 * @param query 查询条件，属性为null或‘’,不包含此条件
	 * @param sqlId 指定的sqlId，不包含namespace
	 * @return 翻页的VO
	 * @author wzy
	 * @date 2022/9/30 17:34
	 */
	Paging<E> findPaging(V query, String sqlId);
	/**
	 * 老的翻页方法，不再推荐使用
	 * @param query 查询条件
	 * @return V
	 * @author wzy
	 * @Deprecated 2022/8/25不再建议使用，建议使用findPaging
	 * @date 2022/8/25 16:16
	 */
	@Deprecated
	V findPage(V query);



	/**
	 * 执行插入操作，如果entity中值为null,那么对应的字段将不执行插入，这样就可以使用数据库中的默认值了<br/>
	 * <b>此方法要求数据库表必须有主键，支持组合主键，否则会报错</b>
	 * @param entity 插入的实体
	 * @return int 插入的行数
	 * @author wzy
	 * @date 2022/9/28 12:28
	 */
	int insertSelective(E entity);

	/**
	 * 老的插入方法，不再推荐使用
	 * @param entity 实体
	 * @return 更新的行数
	 * @author wzy
	 * @Deprecated 2023/3/15不再建议使用，建议使用insertSelective
	 * @date 2023/3/15 22:22
	 */
	@Deprecated
	public int insert(E entity);
}
