package com.peak.prd.base.dao.imple;

import com.peak.common.util.ConvertUtil;
import com.peak.framework.common.BaseEntity;
import com.peak.framework.common.BaseIbatis3Dao;
import com.peak.framework.common.page.IPage;
import com.peak.framework.common.page.IQuery;
import com.peak.framework.common.page.PaginationUtil;
import com.peak.prd.base.dao.IPrdBaseDao;
import com.peak.prd.base.model.Paging;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class PrdBaseDao<E extends BaseEntity,PK,V extends IQuery<E>> 
										extends BaseIbatis3Dao<E,PK,V> 
										implements IPrdBaseDao<E,PK,V> {
	
	@Override
	/** generator生成器产生mapper的namespace */
	public String getNamespace() {
		return this.getClass().getSimpleName();
	}

//	/** 业务功能的namespace */
//	public abstract String getCustomNamespace();

	/**
	 * findAll的分页版本
	 */
	public List<E> findList(V query) {
		return findList(query, "findAll");
	}
	
	@Override
	public List<E> findList(V query, String sqlId) {
		if (query == null) {
			return null;
		}
		query.getPage().setTotalCount(Integer.MAX_VALUE); // 必须的，否则传入的pageNumber会被重置为1
		PaginationUtil paginationUtil = new PaginationUtil(query.getPage());
	    int offset = paginationUtil.getThisPageFirstRowNumber();
		int limit = query.getPage().getPageSize();
		return this.getSqlSessionTemplate().selectList(this.getNamespace()+"."+sqlId, query, offset, limit);
	}
	
	@Override
	public <T> List<T> findList(V query, String sqlId, Class<T> clazz) {
		if (query == null) {
			return null;
		}
		query.getPage().setTotalCount(Integer.MAX_VALUE); // 必须的，否则传入的pageNumber会被重置为1
		PaginationUtil paginationUtil = new PaginationUtil(query.getPage());
	    int offset = paginationUtil.getThisPageFirstRowNumber();
		int limit = query.getPage().getPageSize();
		return this.getSqlSessionTemplate().selectList(this.getNamespace()+"."+sqlId, query, offset, limit);
	}
	
	/**
	 * findList(pageSize=1)
	 */
	public E findOne(V query) {
		query.getPage().setPageSize(1);
		List<E> list = this.findList(query);
		if (list == null || list.isEmpty()) {
			return null;
		}
		return list.get(0);
	}
	
	/**
	 * selectOne
	 */
	public Object selectOne(V query, String sqlId) {
		return this.getSqlSessionTemplate().selectOne(this.getNamespace()+"."+sqlId, query);
	}
	
	/** getByIds */
	public List<E> getByIds(List<PK> ids) {
		if (ids == null) return null;
		if (ids.isEmpty()) return new ArrayList<E>();
		
		Map<String, List<PK>> map = new HashMap<String, List<PK>>();
		map.put("ids", ids);
		
		return this.getSqlSessionTemplate().selectList(this.getNamespace()+".getByIds", map);
	}
	
	@Override
	public long count(V query, String sqlId) {
		return (long)this.getSqlSessionTemplate().selectOne(this.getNamespace()+"."+sqlId, query);
	}

	@Override
	public List<E> findAll(V query, String sqlId) {
		return this.getSqlSessionTemplate().selectList(this.getNamespace()+"."+sqlId, query,1,5000);
	}

	/**
	 * 老的翻页方法，不再推荐使用
	 * @param query 查询条件
	 * @return 翻页对象
	 * @author wzy
	 * @Deprecated 2022/8/25不再建议使用，建议使用findPaging
	 * @date 2022/8/25 14:31
	 *
	 */
	@Override
	@Deprecated
	public V findPage(V query) {
		return super.findPage(query);
	}

	@Override
	public <VO> Paging<VO> findPaging(V query, Class<VO> clazz) {
		IPage<E> page = this.findPage(query).getPage();
		List<VO> voList = ConvertUtil.convert(page.getClearResult(),clazz);
		return new Paging<>(page,voList);
	}
	@Override
	public <VO> Paging<VO> findPaging(V query,String sqlId, Class<VO> clazz) {
		IPage<E> page = pageQuery(this.getSqlSessionTemplate(), this.getNamespace()+"."+sqlId,
				this.getCountStatementForPaging(this.getNamespace()+"."+sqlId), query).getPage();
		List<VO> voList = ConvertUtil.convert(page.getClearResult(),clazz);
		return new Paging<>(page,voList);
	}

	@Override
	public Paging<E> findPaging(V query) {
		IPage<E> page = this.findPage(query).getPage();
		return new Paging<>(page);
	}
	@Override
	public Paging<E> findPaging(V query,String sqlId) {
		IPage<E> page = pageQuery(this.getSqlSessionTemplate(), this.getNamespace()+"."+sqlId,
				this.getCountStatementForPaging(this.getNamespace()+"."+sqlId), query).getPage();
		return new Paging<>(page);
	}

	@Override
	public int insertSelective(E entity) {
		return this.getSqlSessionTemplate().insert(this.getNamespace()+".insertSelective", entity);
	}

	/**
	 * 老的插入方法，不再推荐使用
	 * @param entity 实体
	 * @return 更新的行数
	 * @author wzy
	 * @Deprecated 2023/3/15不再建议使用，建议使用insertSelective
	 * @date 2023/3/15 22:22
	 *
	 */
	@Override
	@Deprecated
	public int insert(E entity) {
		return super.insert(entity);
	}
}
