package com.peak.prd.base.job;/**
 * 功能描述:
 *
 * @author zhk
 * @version 1.0
 * @since 1.0   - 2025/3/4
 */

import lombok.extern.slf4j.Slf4j;
import tech.powerjob.worker.core.processor.ProcessResult;
import tech.powerjob.worker.core.processor.TaskContext;
import tech.powerjob.worker.core.processor.sdk.BasicProcessor;

/**
 * <p> IBaseJobProcessor</p >
 * <p> com.peak.prd.base.job</p > 
 * <p> 2025/3/4 20:23 </p >
 * @author zhk
 */
@Slf4j
public abstract class BaseJobProcessor implements BasicProcessor {

    @Override
    public ProcessResult process(TaskContext taskContext) throws Exception {
        long start = System.currentTimeMillis();
        // 1. 初始化日志工具
        JobHelper.init(taskContext);

        // 2. 直接使用工具类记录日志
        JobHelper.info("任务开始执行，JobId :{}  参数: {}", taskContext.getJobId(),taskContext.getJobParams());

        // 3. 执行任务
        this.runJob(taskContext.getJobParams());

        // 4. 任务执行完成返回状态记录日志
        JobHelper.info("任务执行完成");

        // 5. 清理ThreadLocal
        JobHelper.clear();

        return new ProcessResult(true, "执行成功");

    }


    public abstract void runJob(String jobParams) throws Exception;
}
