package com.peak.prd.base.job;/**
 * 功能描述:
 *
 * @author zhk
 * @version 1.0
 * @since 1.0   - 2025/3/7
 */

import tech.powerjob.worker.core.processor.TaskContext;
import tech.powerjob.worker.log.OmsLogger;

/**
 * <p> JobHelper</p >
 * <p> com.peak.prd.base.job</p > 
 * <p> 2025/3/7 15:26 </p >
 * @author zhk
 */
public class JobHelper {

    // 使用ThreadLocal保存每个线程的OmsLogger实例
    private static final ThreadLocal<TaskContext> OMS_CONTEXT_HOLDER = new ThreadLocal<>();

    private JobHelper() {
        // 私有构造防止实例化
    }

    /**
     * 初始化工具类，必须在任务处理开始时调用
     * @param context 任务上下文
     */
    public static void init(TaskContext context) {
        if (context == null) {
            throw new IllegalArgumentException("TaskContext cannot be null");
        }
        OMS_CONTEXT_HOLDER.set(context);
    }

    /**
     * 清理ThreadLocal，防止内存泄漏，建议在任务结束时调用
     */
    public static void clear() {
        OMS_CONTEXT_HOLDER.remove();
    }

    public static void debug(String msg, Object... var2) {
        getLogger().debug(msg,var2);
    }

    public static void info(String msg, Object... var2) {
        getLogger().info(msg,var2);
    }

    public static void warn(String msg, Object... var2) {
        getLogger().warn(msg,var2);
    }

    public static void error(String msg, Object... var2) {
        getLogger().error(msg,var2);
    }

    public static void error(String msg, Throwable t) {
        getLogger().error(msg, t);
    }

    // 核心方法：获取当前线程的Logger实例
    private static OmsLogger getLogger() {
        TaskContext taskContext = OMS_CONTEXT_HOLDER.get();
        OmsLogger logger = null;
        if(taskContext!=null){
            logger = taskContext.getOmsLogger();
        }

        if (logger == null) {
            throw new IllegalStateException("OmsLogger未初始化! 请确保在任务处理方法中调用PowerJobHelper.init(TaskContext)");
        }
        return logger;
    }

    public static String getJobParams() {
        String jobParams = "";
        TaskContext taskContext = OMS_CONTEXT_HOLDER.get();
        if(taskContext!=null){
            jobParams = taskContext.getJobParams();
        }

        return jobParams;
    }

    public static long getJobId() {
        Long jobId =null;
        TaskContext taskContext = OMS_CONTEXT_HOLDER.get();
        if(taskContext!=null){
            jobId = taskContext.getJobId();
        }

        return jobId == null ? -1L : jobId.longValue();
    }

    public static String getTaskId() {
        String taskId =null;
        TaskContext taskContext = OMS_CONTEXT_HOLDER.get();
        if(taskContext!=null){
            taskId = taskContext.getTaskId();
        }

        return taskId;
    }

    public static String getTaskName() {
        String taskName =null;
        TaskContext taskContext = OMS_CONTEXT_HOLDER.get();
        if(taskContext!=null){
            taskName = taskContext.getTaskName();
        }

        return taskName;
    }

}
