package com.peak.prd.base.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.peak.framework.common.page.IPage;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

/**
 * 通用接口返回格式，一般情况下controller方法都应该返回本类实例
 * @author zhangdexin
 */
@ApiModel("通用接口返回")
public class ApiResult<T> implements Serializable {
	private static final long serialVersionUID = 1L;
	
	public static final int STATUS_OK  = 200; // 正常
	public static final int STATUS_ERR = 500; // 服务器端错误
	public static final int STATUS_CLIENT_ERR = 400; // 客户端错误（提供的参数格式有问题等）
	
	public static final String CODE_PARAM_VAL_EMPTY = "401";  //必要参数为空
	public static final String CODE_PARAM_USERL_NULL = "402";  //未能获得的用户
	public static final String CODE_SEARCH_FAIL = "501";  //查询数据操作失败
	public static final String CODE_SAVE_FAIL = "502";  //保存数据失败
	public static final String CODE_UPDATE_FAIL = "503";  //更新数据失败
	public static final String CODE_DELETE_FAIL = "504";  //删除数据失败
	
	private static final List LIST_SIZE_ZERO = new ArrayList();

	/** 返回状态码 */
	@ApiModelProperty(value = "200成功/500服务器错误/400客户端参数错误")
	int status; 
	
	/** 英文提示信息 */
	String code;
	
	/** 中文、英文提示信息 */
	String msg;
	
	/** 业务数据 */
	T data;
	
	/** 时间戳 */
	@JsonFormat(timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
	Date timestamp = new Date();
	
	
	public int getStatus() {
		return status;
	}

	public void setStatus(int status) {
		this.status = status;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getMsg() {
		return msg;
	}

	public void setMsg(String msg) {
		this.msg = msg;
	}

	public T getData() {
		return data;
	}

	public void setData(T data) {
		this.data = data;
	}

	public Date getTimestamp() {
		return timestamp;
	}

	public void setTimestamp(Date timestamp) {
		this.timestamp = timestamp;
	}

	/** 成功，code=null、msg=null、data=null */
	public static ApiResult ok() {
		ApiResult ar = new ApiResult();
		ar.status = STATUS_OK;
		return ar;
	}
	
	/** 成功并设置msg */
	public static ApiResult okMsg(String msg) {
		ApiResult ar = new ApiResult();
		ar.status = STATUS_OK;
		ar.msg = msg;
		return ar;
	}
	
//	/** 成功并返回分页数据 */
//	public static ApiResult okPage(IQuery query) {
//		return okPage(query.getPage(), query.getPage().getClearResult());
//	}
	/** 成功并返回分页数据 */
	public static <T> ApiResult<Paging<T>> okPage(Paging<T> page) {
		ApiResult<Paging<T>> ar = new ApiResult<Paging<T>>();		
		ar.status = STATUS_OK;
		ar.data = page;
		return ar;
	}
	
	/** 成功并返回分页数据 */
	public static <T> ApiResult<Paging<T>> okPage(IPage<T> page) {
		return okPage(page, page == null ? null : page.getResult());
	}
	
	/** 成功并返回分页数据 */
	public static <T> ApiResult<Paging<T>> okPage(IPage<T> page, List<T> list) {
		ApiResult<Paging<T>> ar = new ApiResult<Paging<T>>();		
		ar.status = STATUS_OK;
		Paging<T> paging = new Paging<T>();
		if (page != null) {
			paging.setPageNumber(page.getPageNumber());
			paging.setPageSize(page.getPageSize());
			paging.setTotalCount(page.getTotalCount());			
		}
		if (list == null) list = LIST_SIZE_ZERO;
		paging.setList(list);
		ar.data = paging;
		return ar;
	}
	
	/** 成功并返回分页数据 */
	public static ApiResult okPage(Integer pageNumber,Integer pageSize , Long totalCount, List list) {
		ApiResult ar = new ApiResult();
		ar.status = STATUS_OK;
		Map<String, Object> map = new HashMap<String, Object>();
		map.put("pageNumber", pageNumber);
		map.put("pageSize", pageSize);
		map.put("totalCount", totalCount);
		map.put("list", list == null ? LIST_SIZE_ZERO : list);
		ar.data = map;
		return ar;
	}
	
	/** 成功并返回数据 */
	public static <T> ApiResult<T> okData(T data) {
		ApiResult<T> ar = new ApiResult<T>();
		ar.status = STATUS_OK;
		ar.data = data;
		return ar;
	}
	
	/** 失败并设置msg */
	public static ApiResult errMsg(String msg) {
		ApiResult ar = new ApiResult();
		ar.status = STATUS_ERR;
		ar.msg = msg;
		return ar;
	}
	
	/** 客户端参数错误并设置msg */
	public static ApiResult errParamMsg(String msg) {
		ApiResult ar = new ApiResult();
		ar.status = STATUS_CLIENT_ERR;
		ar.msg = msg;
		return ar;
	}
	
	/** 失败并设置data */
	public static ApiResult errData(Object data) {
		ApiResult ar = new ApiResult();
		ar.status = STATUS_ERR;
		ar.data = data;
		return ar;
	}
	
	/** 失败并设置code和msg */
	public static ApiResult errCodeMsg(String code, String msg) {
		ApiResult ar = new ApiResult();
		ar.status = STATUS_ERR;
		ar.code = code;
		ar.msg = msg;
		return ar;
	}
	
	/** 失败并设置msg和data */
	public static ApiResult errMsgData(String msg, Object data) {
		ApiResult ar = new ApiResult();
		ar.status = STATUS_ERR;
		ar.msg = msg;
		ar.data = data;
		return ar;
	}

	
}
