package com.peak.prd.base.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
//import java.util.concurrent.TimeUnit;

public class CountSetting {
	private String className, field;
	private String entityClassName, entityField, entityIdField;
	private String entityService;
	
	/**
	 * @param voClassName VO类名
	 * @param voField VO的计数字段
	 * @param entityClassName  VO的计数字段对应的实体类名
	 * @param entityField 实体的计数字段
	 * @param entityIdField 实体的id字段
	 * @param entityService 实体的service
	 */
	public CountSetting(String voClassName, String voField, String entityClassName, String entityField, String entityIdField, String entityService) {
		this.className = voClassName;
		this.field = voField;
		this.entityClassName = entityClassName;
		this.entityField = entityField;
		this.entityIdField = entityIdField;
		this.entityService = entityService;
	}

	/**
	 * @param voClassName VO类名
	 * @param voField VO的计数字段
	 * @param entityClassName  VO的计数字段对应的实体类名
	 * @param entityField 实体的计数字段
	 * @param entityIdField 实体的id字段
	 */
	public CountSetting(String voClassName, String voField, String entityClassName, String entityField, String entityIdField) {
		this(voClassName, voField, entityClassName, entityField, entityIdField
				, entityClassName.substring(0, 1).toLowerCase() + entityClassName.substring(1) + "PlusService");
	}
	
	/**
	 * @param entityClassName  计数字段对应的实体类名
	 * @param entityField 计数字段
	 * @param entityIdField id字段
	 */
	public CountSetting(String entityClassName, String entityField, String entityIdField) {
		this(entityClassName, entityField, entityClassName, entityField, entityIdField);
	}
	
	public String getClassName() {
		return className;
	}

	public String getField() {
		return field;
	}

	public String getEntityClassName() {
		return entityClassName;
	}

	public String getEntityField() {
		return entityField;
	}

	public String getEntityIdField() {
		return entityIdField;
	}

	public String getEntityService() {
		return entityService;
	}

	private static Map<String, List<CountSetting>> mapCountSetting = new HashMap<String, List<CountSetting>>();
	
	/**
	 * 初始化mapCountSetting
	 *
	 */
	private static void setMapCountSetting() {
		List<CountSetting> csList = new ArrayList<CountSetting>();
		CountSetting[] csArray = CountSettings.getCountSettings();
		if (csArray == null) return;
		
		for (CountSetting cs : csArray) {
			csList.add(cs);
			if (!cs.getClassName().equals(cs.getEntityClassName())) {
				CountSetting c = new CountSetting(cs.getEntityClassName(), cs.getEntityField(), 
												  cs.getEntityClassName(), cs.getEntityField(), 
												  cs.getEntityIdField(), cs.getEntityService());
				csList.add(c);
			}
		}
		
		for (CountSetting cs : csList) {
			List<CountSetting> list = mapCountSetting.get(cs.getClassName());
			if (list == null) {
				list = new ArrayList<>();
			}
			
			list.add(cs);
			mapCountSetting.put(cs.getClassName(), list);
		}
	}
	
	public static List<CountSetting> match(String className) {
//		如果还未初始化进行初始化
		if (mapCountSetting == null || mapCountSetting.size() == 0) {
//			try {
//				TimeUnit.MILLISECONDS.sleep(10L);
//			} catch (InterruptedException e) {
//				throw new RuntimeException(e);
//			}
			synchronized (CountSetting.class) {
				if (mapCountSetting == null || mapCountSetting.size() == 0) {
					setMapCountSetting();
				}
			}
		}
		return mapCountSetting.get(className);
	}
	
	public static CountSetting match(String className, String field) {
//		如果还未初始化进行初始化
		if (mapCountSetting == null || mapCountSetting.size() == 0) {
//			try {
//				TimeUnit.MILLISECONDS.sleep(10L);
//			} catch (InterruptedException e) {
//				throw new RuntimeException(e);
//			}
			synchronized (CountSetting.class) {
				if (mapCountSetting == null || mapCountSetting.size() == 0) {
					setMapCountSetting();
				}
			}
		}
		List<CountSetting> css = mapCountSetting.get(className);
		if (css == null) return null;
		for (CountSetting cs : css) {
			if (cs.getClassName().equals(className) && cs.getField().equals(field)) {
				return cs;
			}
		}
		return null;
	}

	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder();
		sb.append("className:").append(className).append(",");
		sb.append("field:").append(field).append(",");
		sb.append("entityClassName:").append(entityClassName).append(",");
		sb.append("entityField:").append(entityField).append(",");
		sb.append("entityIdField:").append(entityIdField).append(",");
		sb.append("entityService:").append(entityService).append(",");

		return sb.toString();
	}
	
}
