package com.peak.prd.base.model;

/**
 * 需要将全部计数字段在这里初始化
 * @author zhangdexin
 *
 */
public class CountSettings {

	// 计数字段目前只支持Long或者Integer类型
	// 请参考CountSetting的几个构造函数注释
	// 如果有VO包装，那么实体计数类不用再单独声明，否则需要单独为实体计数类声明
	private static CountSetting[] countSettings;

	public static CountSetting[] getCountSettings() {
		return countSettings;
	}

	// 修改方法，使用动态注册，外部无感知，这样同一个微服务里面可以有多个不同名称的CountSettingConfig
	public synchronized static void setCountSettings(CountSetting[] registeredCountSettings) {
		CountSettings.countSettings = merge(countSettings, registeredCountSettings);
	}

	/**
	 * @description 将两个数组合并为一个
 	 * @param countSettings1
 	 * @param countSettings2
	 * @return
	 * @author ZhegnJia
	 * @date 2023/9/12 1:45 PM
	 **/
	private static CountSetting[] merge(CountSetting[] countSettings1, CountSetting[] countSettings2) {
		if(isEmpty(countSettings1) && isEmpty(countSettings2)) {
			return new CountSetting[]{};
		} else if(isEmpty(countSettings1)) {
			return countSettings2;
		} else if(isEmpty(countSettings2)) {
			return countSettings1;
		} else {
			CountSetting[] countSettings = new CountSetting[countSettings1.length + countSettings2.length];
			System.arraycopy(countSettings1, 0, countSettings, 0, countSettings1.length);
			System.arraycopy(countSettings2, 0, countSettings, countSettings1.length, countSettings2.length);
			return countSettings;
		}
	}

	/**
	 * @description 判断数组是否为空
 	 * @param countSettings
	 * @return
	 * @author ZhegnJia
	 * @date 2023/9/12 1:48 PM
	 **/
	private static boolean isEmpty(CountSetting[] countSettings) {
		return countSettings == null || countSettings.length == 0;
	}

}
