package com.peak.prd.base.model;

import java.util.List;

import com.peak.framework.common.page.IPage;
/**
 * 用于新的翻页
 * @author peaktele
 *
 * @param <T>
 */
public class Paging<T> {
	
	private int pageNumber;//页码
	private int pageSize;//每页条数
	private long totalCount;//总条数
	private List<T> list;//每页的数据集
	
	public Paging() {}
	
	public Paging(int pageNumber, int pageSize) {
	    if (pageSize <= 0) {
	      throw new IllegalArgumentException("[pageSize] must great than zero");
	    }
	    this.pageSize = pageSize;
	    this.pageNumber = pageNumber;
	} 
	
	public Paging(IPage<T> page) {
		this.pageNumber = page.getPageNumber();
		this.pageSize = page.getPageSize();
		this.totalCount = page.getTotalCount();
		this.list = page.getResult();
	}
	
	public Paging(IPage page, List<T> list) {
		this.pageNumber = page.getPageNumber();
		this.pageSize = page.getPageSize();
		this.totalCount = page.getTotalCount();
		this.list = list;
	}
	
	/**
	 * 获得当前页码
	 * @return 当前页码
	 *
	 */
	public int getPageNumber() {
		return pageNumber;
	}
	/**
	 * 设置当前页码
	 * @param pageNumber 当前页码
	 *
	 */
	public void setPageNumber(int pageNumber) {
		this.pageNumber = pageNumber;
	}
	/**
	 * 获得每页条数
	 * @return 每页条数
	 *
	 */
	public int getPageSize() {
		return pageSize;
	}
	/**
	 * 设置每页条数
	 * @param pageSize 每页条数
	 *
	 */
	public void setPageSize(int pageSize) {
		this.pageSize = pageSize;
	}
	/**
	 * 获得总条数
	 * @return 总条数
	 *
	 */
	public long getTotalCount() {
		return totalCount;
	}
	/**
	 * 设置总条数
	 * @param totalCount 总条数
	 *
	 */
	public void setTotalCount(long totalCount) {
		this.totalCount = totalCount;
	}
	/**
	 * 获得本页结果集
	 * @return
	 *
	 */
	public List<T> getList() {
		return list;
	}
	/**
	 * 设置本页结果集
	 * @param list 本页结果集
	 *
	 */
	public void setList(List<T> list) {
		this.list = list;
	}	
	
	/**
	 * 判断list是否为null或者empty
	 * @return
	 */
	public boolean isListNullOrEmpty() {
		return this.list == null || this.list.isEmpty();
	}

}
