package com.peak.prd.base.model;

import java.util.Calendar;
import java.util.Date;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.peak.framework.common.BaseEntity;

/**
 * model的基类
 * @author zhangdexin
 *
 */
@JsonIgnoreProperties({ "showCheckBox", "checked", "extSql", "leaf", "ask", "askType", "qShow", "new", "inputHidden", "today", "yesterday", "tomorrow", "now", "columns" })
public abstract class PrdBaseEntity extends BaseEntity {

	private static final long serialVersionUID = 1L;

	@Override
	public boolean isNew() {
		return false;
	}
	
	/** 今天-0点0分0秒 */
	public Date getToday() {
		Calendar calendar = Calendar.getInstance();
		calendar.set(Calendar.HOUR_OF_DAY, 0);
		calendar.set(Calendar.MINUTE, 0);
		calendar.set(Calendar.SECOND, 0);
		calendar.set(Calendar.MILLISECOND, 0);
		return calendar.getTime();
	}
	
	/** 明天-0点0分0秒 */
	public Date getTomorrow() {
		Calendar calendar = Calendar.getInstance();
		calendar.set(Calendar.HOUR_OF_DAY, 0);
		calendar.set(Calendar.MINUTE, 0);
		calendar.set(Calendar.SECOND, 0);
		calendar.set(Calendar.MILLISECOND, 0);
		
		calendar.add(Calendar.DAY_OF_MONTH, 1);
		return calendar.getTime();
	}
	
	/** 昨天-0点0分0秒 */
	public Date getYesterday() {
		Calendar calendar = Calendar.getInstance();
		calendar.set(Calendar.HOUR_OF_DAY, 0);
		calendar.set(Calendar.MINUTE, 0);
		calendar.set(Calendar.SECOND, 0);
		calendar.set(Calendar.MILLISECOND, 0);
		
		calendar.add(Calendar.DAY_OF_MONTH, -1);
		return calendar.getTime();
	}
	
	/** 当前时间 */
	public Date getNow() {
		return new Date();
	}
	
	/** 手工指定查询字段 */
	public String getColumns() {
		return this.getExtSql();
	}
	
	/** 手工指定查询字段 */
	public void setColumns(String columns) {
		// 借用extSql属性
		this.setExtSql(columns);
	}
	
}
