package com.peak.prd.base.model;
/**
 * 响应结果枚举，用于提供给ApiResult返回给前端的
 * @author peaktele
 *
 */
public enum ResponseStatusEnum implements  IRespStatusEnum{
    //标准状态码定义：https://developer.mozilla.org/en-US/docs/Web/HTTP/Status
	 SUCCESS(200, "200", "操作成功！"),
	 FAILED(500, "500", "操作失败！"),
	
	//用户相关异常50x、51x
    USER_UN_LOGIN(501,"501","请登录后再继续操作！"),
    USER_TICKET_INVALID(502,"502","会话失效，请重新登录！"),
    USER_NO_AUTH(503,"503","您的权限不足，无法继续操作！"),
    USER_FROZEN(504,"504","用户已被冻结，请联系管理员！"),
    USER_USERNAME_SAME(505,"505","用户名已存在，请重新输入！"),
    USER_INACTIVE_ERROR(506,"506","请前往[账号设置]修改信息激活后再进行后续操作！"),
    USER_STATUS_ERROR(507,"507","用户状态参数出错！"),
    USER_NOT_EXIST_ERROR(508,"508","用户不存在！"),
    USER_PWD_ERROR(509,"509","原密码输入不正确！"),
    USER_NEWOLDPWD_SAME_ERROR(510,"510","新密码与原来密码相同！"),
    USER_CLIENT_PWD_ERROR(511,"511","客户端密码未加密或加密错误！"),
    USERID_IS_NULL(512,"512","用户Id为null！"),
    USER_ADD_IS_NULL(513, "513", "需要选择指定人员！"),

    //课程相关的异常53x
    LESSON_NOTLEARN_ERROR(531,"531","课程因未发布或已经过期等原因，已经无法访问，如需访问，请联系管理员！"),
    LESSON_COURSEWAREFILE_ERROR(532,"532","文件包中找不到适合的index.html或index.htm,请重新上传!"),
    LESSON_COURSEWARENULL(533,"533","课程还未上传课件，请上传！"),
    LESSON_COURSEWARENEEDCONVERT(534,"534","课程存在未转换完成课件，需要等待转换完成！"),
    LESSON_COURSEWARE_NAME_NULL(535,"535","存在课件名称为空的数据，请填写！"),
    LESSON_COURSEWARE_PLAYTIME_NULL(536,"536","存在课件播放时长为空的数据，请填写！"),
    LESSON_CHAPTER_NAME_NULL(537,"537","存在章节名称为空的数据，请填写！"),
    LESSON_IMPORT_LIST_NULL(538,"538","导入的课程数据为空，无法导入！"),
    LESSON_COURSEWARE_IMPORT_LIST_NULL(539,"539","导入的课件数据为空，无法导入！"),
    LESSON_NO_OUTER_LEARN(5311,"5311","此课程不能通过外网学习，请到内网学习此课程！"),

    //权限相关的异常54x
    UNAUTHORIZED_ERROR(541,"541","无权访问，如需访问，请联系管理员！"),

    //业务功能错误55x
    UNADAPT_PC_EQUITMENT(551,"551","不支持电脑端，请切换到移动端！"),
    UNADAPT_MOBILE_EQUITMENT(552,"552","不支持移动端，请切换到电脑端！"),
    NOTSTART_ENTER_DETAILPAGE(553,"553","还未到开始时间，不允许进入！"),
    HADEND_ENTER_DETAILPAGE(554,"554","已到结束时间，不允许进入！"),
    REPEATED_ENTRY_PAPER_ERROR(555,"555","此问卷已经提交过了，不允许再次提交！"),
    REPEATED_ANSWER_PAPER_ERROR(556,"556","您还没有参加过此问卷，不能查看答题结果！"),
    
    
    //数量限制相关异常56x
    CLASSMATE_NUM_ERROR(561,"561","同学列表数量不允许超过100！"),
    QUERY_NUM_ERROR(562,"562","数量不允许超过200！"),
    MAX_PAGESIZE_ERROR(563,"563","超出了每页最大行数（1000行）！"),

    
	 
    
    //文件相关异常57x
    FILE_EXT_ERROR(571,"571","文件类型不在允许的范围内，请重新选择！"),
    FILE_UPLOAD_FAILD(572,"572","文件上传失败！"),
    FILE_UPLOAD_OVER_MAXNUM(573,"573","超过允许上传的文件最大数限制！"),
    FILE_DOWNLOAD_FAILD(574,"574","文件下载失败！"),
    FILE_IMG_DOWNLOAD_FAILD(575,"575","文件只能是图片类型，请重新选择"),
    FILE_IMPORTEXCEL_ISNULL(576,"576","导入的zip包中的excel文件未找到！"),
    FILE_IMPORTEXCEL_OVER_MAXNUM(577,"577","导入的zip包中的excel文件只能是1个！"),

    FILE_SIZE_ERROR(578,"common578" , "文件大小超过允许上传的限制，请重新选择！"),
	 
	// 自定义系统级别异常 58x
    SYSTEM_INDEX_OUT_OF_BOUNDS(581, "581", "系统错误，数组越界！"),
    SYSTEM_ARITHMETIC_BY_ZERO(582, "582", "系统错误，无法除零！"),
    SYSTEM_NULL_POINTER(583, "583", "系统错误，空指针！"),
    SYSTEM_PARSE(584, "584", "系统错误，解析异常！"),
    SYSTEM_IO(585, "585", "系统错误，IO输入输出异常！"),
    SYSTEM_FILE_NOT_FOUND(586, "586", "系统错误，文件未找到！"),
    SYSTEM_CLASS_CAST(587, "587", "系统错误，类型转换错误！"),
    SYSTEM_PARSER_ERROR(588, "588", "系统错误，解析出错！"),
	 
	// 系统错误，未预期的错误 59x
    SYSTEM_ERROR(591, "591", "系统繁忙，请稍后再试！"),
    SYSTEM_OPERATION_ERROR(592, "592", "操作失败，请重试或联系管理员"),
    SYSTEM_RESPONSE_NO_INFO(593, "593", ""),
    SYSTEM_ERROR_GLOBAL(594, "594", "全局降级：系统繁忙，请稍后再试！"),
    SYSTEM_ERROR_FEIGN(595, "595", "客户端Feign降级：系统繁忙，请稍后再试！"),
    SYSTEM_ERROR_GATEWAY(596, "596", "请求系统过于繁忙，请稍后再试！"),

    
    //文档相关异常63x
  	DOCUMENT_NOT_EXIST_ERROR(631, "631", "文档不存在！"),
    DOCUMENT_NOT_DELETE(632, "632", "不能删除非本人的文档！"),
    DOCUMENT_NOT_UPDATE(633, "633", "不能修改非本人的文档！"),
    
    //培训评估相关的异常70x
    TRAINEVAL_EAVLSET_WEIGHT_NULL(701, "701", "启用评估模板必须设置有效的权重！"),
    TRAINEVAL_EAVLSET_WEIGHT_NOT100(702, "702", "评估模板设置权重值不是100%！"),
    TRAINEVAL_EAVLSET_PAPERID_NULL(703, "703", "启用评估模板必须设置有效的问卷！"),
    TRAINEVAL_PAPER_NOT_EXIST_ERROR(704, "704", "评估问卷不存在！"),
    
    //excel导入导出相关错误 90x
	EXCEL_READ_ERRORNUMOVERSTEP(901, "901", "Excel导入错误行数超过1000条"),
	EXCEL_WRITER_ERROR_DATANULL(902, "902", "Excel导出数据不能为空"),
	EXCEL_WRITER_ERROR_DATAOVERSTEP(903, "903", "Excel导出数据每次最多不能超过2000条"),

	//内容管理相关错误 100x, 101x
    CONTENT_CHANNEL_NOT_EXISTS(1001, "1001", "指定的Channel不存在"),
    CONTENT_STATUS_INVALID(1002, "1002", "是否发布字段不合法"),
    CONTENT_TXT_IS_EMPTY(1003, "1003", "新闻内容为NULL或者空"),
    CONTENT_NOT_EXISTS(1004, "1004", "指定的Content不存在"),
    CONTENT_CONTENT_ID_IS_NULL(1005, "1005", "contentId为NULL"),
    CONTENT_COVERPICBASE64_IS_NULL(1006, "1006", "封面图片base64为NULL"),
    CONTENT_COVERPICBASE64_AND_COVERPIC_IS_NULL(1007, "1007", "封面图片base64和coverpic都为NULL"),
    CONTENT_EQUIPMENT_IS_NULL(1008, "1008", "适用终端字段为NULL"),
    CONTENT_TOPLEVEL_IS_NULL(1009, "1009", "是否置顶字段为NULL"),
    CONTENT_PCSTYLE_IS_NULL(1010, "1010", "PC版式字段为NULL"),
    CONTENT_MOBILESTYLE_IS_NULL(1011, "1011", "移动版式字段为NULL"),
    CONTENT_COVERPICBASE64LIST_IS_EMPTY(1012, "1012", "标题图片base64列表字段为NULL或者空列表"),
    CONTENT_CONTENT_ID_IS_NOT_NULL(1013, "1013", "contentId不为NULL"),
    CONTENT_ISLINK_IS_NULL(1014, "1014", "是否为链接字段为NULL"),
    CONTENT_PCLINK_IS_NULL(1015, "1015", "pc端链接字段为NULL"),
    CONTENT_APPLINK_IS_NULL(1016, "1016", "app端链接字段为NULL"),
    CONTENT_COVERPICBASE64LIST_SIZE_GT_1(1017, "1017", "标题图片base64列表size大于1"),
    CONTENT_TOPLEVEL_INVALID(1018, "1018", "是否置顶字段不合法"),
    CONTENT_TXT_TOO_LONG(1019, "1019", "内容长度过长"),

    // 移动端首页相关错误 102x
    PAGETPL_PAGETPLID_IS_NOT_NULL(1021, "1021", "模板id不为NULL"),
    PAGETPL_PAGETPL_NOT_EXISTS(1022, "1022", "指定的模板不存在"),
    PAGETPL_PAGETPL_IS_NOT_FRONTPAGE(1023, "1023", "指定的模板不是移动端首页类型"),

    //域管理相关错误 103x
    DOMAIN_ALREADY_RELATED(1031, "1031", "父域和子域已经存在关联关系"),

    // 用户组功能相关 104x
    GROUP_COMMON_CONTAINS_WHITELIST(1041, "1041", "普通用户组存在白名单"),
    GROUP_COMMON_CONTAINS_MATCHRULE(1042, "1042", "普通用户组存在过滤规则"),
    GROUP_INSERT_GROUP_ID_IS_NOT_NULL(1043, "1043", "新增用户组groupId不为空"),
    GROUP_UPDATE_GROUP_ID_IS_NULL(1044, "1044", "修改用户组groupId为空"),
    GROUP_NOT_EXISTS(1045, "1045", "指定的用户组不存在"),
    GROUP_WHITELIST_TYPE_INVALID(1046, "1046", "白名单的type不合法"),
    GROUP_BLACKLIST_TYPE_INVALID(1047, "1047", "黑名单的type不合法"),

    // 智能陪练相关 105x 106x
    AI_PRACTICE_ID_IS_NOT_NULL(1051, "1051", "智能陪练的id不为空"),
    AI_PRACTICE_ID_IS_NULL(1052, "1052", "智能陪练的id为空"),
    AI_PRACTICE_PRACTICE_ATTENDTIMES_IS_NULL(1053, "1053", "智能陪练的允许练习次数为空"),
    AI_PRACTICE_EXAM_ATTENDTIMES_IS_NULL(1054, "1054", "智能陪练的允许考试次数为空"),
    AI_PRACTICE_PRACTICE_PAPER_IS_EMPTY(1055, "1055", "智能陪练的练习试卷为空"),
    AI_PRACTICE_EXAM_PAPER_IS_EMPTY(1056, "1056", "智能陪练的考试试卷为空"),
    AI_PRACTICE_EXAM_TIME_IS_NULL(1057, "1057", "智能陪练的考试时长为空"),
    AI_PRACTICE_IS_NULL(1058, "1058", "指定的智能陪练不存在"),
    AI_PRACTICE_IS_DELETED(1059, "1059", "指定的智能陪练已经被删除"),
    AI_PRACTICE_PRACTICE_ARRANGE_IS_NULL(1060, "1060", "智能陪练指定的练习不存在"),
    AI_PRACTICE_EXAM_ARRANGE_IS_NULL(1061, "1061", "智能陪练指定的考试不存在"),

    // 直播相关 107x
    LIVECLASS_CREATE_ERROR(1071, "1071", "直播创建失败"),
    LIVECLASS_CHANNEL_SUPPLIER_NOT_EXIST(1072, "1072", "直播频道供应商不存在"),

    DEFAULT_BUSINESS_STATUS(10000, "10000", "默认的业务状态码"),

    //问答相关的异常121x
    QA_QUESTION_NOT_EXIST_ERROR(1211, "1211", "提问不存在！"),
    QA_QUESTION_NOT_DELETE(1212, "1212", "不能删除非本人的提问！"),
    QA_QUESTION_NOT_UPDATE(1213, "1213", "不能修改非本人的提问！"),
    QA_ANSWER_NOT_EXIST_ERROR(1214, "1214", "提问回答不存在！"),
    QA_ANSWER_NOT_GOOD_ERROR(1215, "1215", "不能采纳非本人提问的回答！"),
    QA_ANSWER_QUESTION_NOT_EXIST_ERROR(1216, "1216", "采纳回答的提问不存在！"),
    QA_ANSWER_GOOD_EXIST_ERROR(1217, "1217", "提问已经存在采纳的回答！"),
    
    //通知模板相关错误 200x
    LMS_TEMPLATE_NOT_EXISTS(2001, "2001", "指定的通知模板不存在"),
    LMS_TEMPLATE_NOT_DELETE(2002, "2002", "有效状态的通知模板不能被删除"),

    //笔记相关错误 210x
    LMS_NOTES_NOT_EXISTS(2101, "2101", "指定的笔记不存在"),
    LMS_NOTES_NOT_DELETE(2102, "2102", "不允许删除其他用户的笔记"),
    LMS_NOTES_NOT_UPDATE(2103, "2103", "不允许编辑其他用户的笔记"),

    //积分相关错误 220x
    POINT_RANK_REPEAT(2201, "2201", "积分等级的积分范围或等级出现重复"),

    //评论相关错误 230x
    COMMENT_NOT_EXIST_ERROR(2301, "2301", "评论不存在！"),
    COMMENT_NOT_DELETE(2302, "2302", "不能删除非本人的评论！"),
    COMMENT_NOT_UPDATE(2303, "2303", "不能修改非本人的评论！"),

    COMMENTREPLY_NOT_EXIST_ERROR(2311, "2311", "评论回复不存在！"),
    COMMENTREPLY_NOT_DELETE(2312, "2312", "不能删除非本人的评论回复！"),
    COMMENTREPLY_NOT_UPDATE(2313, "2313", "不能修改非本人的评论回复！"),
    ;


	// 响应业务状态码
    private Integer status;    
	// 错误编码
    private String code;
    // 响应消息，可以为成功或者失败的消息
    private String msg;

    ResponseStatusEnum(Integer status, String code, String msg) {
        this.status = status;
        this.code = code;
        this.msg = msg;
    }
    /**
     * 获得状态码
     * @return
     * @author wzy
     * @CreateDate 2022年1月12日
     *
     */
    public Integer getStatus() {
		return status;
	}
    /**
     * 获得错误编码
     * @return
     * @author wzy
     * @CreateDate 2022年1月12日
     *
     */
	public String getCode() {
		return code;
	}
	/**
	 * 获得状态信息
	 * @return
	 * @author wzy
	 * @CreateDate 2022年1月12日
	 *
	 */
	public String getMsg() {
		return msg;
	}
}
