package com.peak.prd.base.service;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import java.net.URI;

@Service
public interface IBasePathService {
	/**
	 * 图片的basepath
	 * @param request
	 * @return
	 */
	String getPicBasePath(URI uri);
	
	/**
	 * 图片的basepath
	 * @param request
	 * @return
	 */
	String getPicBasePath(HttpServletRequest request);
	
	/**
	 * 系统basepath
	 * @param request
	 * @return
	 */
	String getBasePath(HttpServletRequest request);
	/**
	 * 获得课程访问basepath
	 * @param request
	 * @return
	 * @author wzy
	 * @CreateDate 2021年11月5日
	 *
	 */
	String getLessonBasePath(HttpServletRequest request);

	/**
	 * 获得视频课件问basepath
	 * @param request
	 * @return 视频课件问basepath
	 * @author wzy
	 * @date 2023/4/13 14:03
	 *
	 */
	String getVideoCoursewareBasePath(HttpServletRequest request);

	/**
	 * <p>获得OSS访问basepath</p >
	 *
	 * @param request
	 * @return java.lang.String
	 * @since   1.0.0
	 * @author zhk
	 * @date 2023/11/20 17:07 </p >
	 */
	String getOssBasePath(HttpServletRequest request);
}
