package com.peak.prd.base.service;

import java.util.List;

/**
 * 数据鉴权<br />
 * 有数据鉴权需求的service，需要实现该接口
 * @author zhangdexin
 *
 */
public interface IDataAuthService<T> {
	
	/**
	 * 对id这行业务数据，进行数据鉴权
	 * @param businessId 业务id（可能null）
	 * @param currUserId 当前用户id（可能null）
	 * @param currMngDomainId 当前管理域id（可能null）
	 * @return 返回通过鉴权的业务对象（根据businessId）
	 */
	T dataAuth(Long businessId, Long currUserId, Long currMngDomainId);
	
	/**
	 * 对ids业务数据，进行数据鉴权
	 * @param businessIds 业务ids（可能null）
	 * @param currUserId 当前用户id（可能null）
	 * @param currMngDomainId 当前管理域id（可能null）
	 * @return 返回通过鉴权的业务对象（根据businessIds -- 去重后，顺序不定）
	 */
	List<T> dataAuth(List<Long> businessIds, Long currUserId, Long currMngDomainId);
	
}
