package com.peak.prd.base.service;

import java.util.List;

/**
 * 对数据所在域进行鉴权<br />
 * @author zhangdexin
 *
 */
public interface IDomainAuthService {
	
	/**
	 * 对单行业务数据，进行数据鉴权
	 * @param domainIdOfData 业务数据所在的domainId
	 * @param currUserId 当前用户id
	 * @param currMngDomainId 当前管理域id
	 * @return 鉴权通过true，不通过false
	 */
	boolean domainAuth(Long domainIdOfData, Long currUserId, Long currMngDomainId);
	
	/**
	 * 对多行业务数据，进行数据鉴权
	 * @param domainIdsOfData 业务数据所在的domainIds
	 * @param currUserId 当前用户id
	 * @param currMngDomainId 当前管理域id
	 * @return 全部鉴权通过true，否则false
	 */
	boolean domainAuth(List<Long> domainIdsOfData, Long currUserId, Long currMngDomainId);
	
}
