package com.peak.prd.base.service;

import org.springframework.stereotype.Service;

import java.io.File;

/**
 * 
 * <p>Oss使用接口，business中根据具体业务具体实现</p>
 * @author ldc
 * @version 1.0
 * @date 2022-8-18 14:01:09
 *
 */
@Service
public interface IOssService {
	
	/**
	 * <p>上传文件到oss</p>
	 * @param localPath			localPath表示本地路径，即获取共享资源目录的本地路径
	 * @param filePathName		文件路径+文件名，不带web/resource/路径，如:2022/08/19/xxxxxx.jpg
	 * @author ldc
	 * @version 1.0
	 * @date 2022-8-18 14:02:56
	 */
	Boolean uploadFile(String localPath, String fileFullPathName);

	/**
	 * <p>获取对象存储资源访问url</p>
	 *
	 * @param url  传入文件访问地址例子：web/resource/*********   如果不是web/resource开头会自动补充，或从web/resource位置开始截取
	 * @return java.lang.String
	 * @since   1.0.0
	 * @author zhk
	 * @date 2023/6/16 0016 12:37 </p>
	 */
	String getUrl(String url);

	/**
	 * <p>获取没有域名的对象存储资源访问url,以web/resource/开头</p >
	 *
	 * @param url 传入文件访问地址例子：web/resource/*********   如果不是web/resource开头会自动补充，或从web/resource位置开始截取
	 * @return java.lang.String
	 * @since   1.0.0
	 * @author zhk
	 * @date 2025/3/26 17:50 </p >
	 */
	//String getUrlNoDomainName(String url);

	/**
	 * <p>获取对象存储资源访问url,不检查传入key是否以web/resource开头</p>
	 *
	 * @param url  不检查传入key是否以web/resource开头 传入什么就以什么请求OSS访问地址
	 * @return java.lang.String
	 * @since   1.0.0
	 * @author zhk
	 * @date 2023/6/16 0016 12:37 </p>
	 */
	String getUrlUnTreatedKey(String url);

	/**
	 * <p></p>
	 *
	 * @param file 下载后本地存放文件路径
	 * @param url web/resource/*********(资源key,不能以/开头)
	 * @since   1.0.0
	 * @author zhk
	 * @date 2023/6/16 0016 18:11 </p>
	 */
	void download(File file, String url) ;

	/**
	 * <p>获取对象存储资源下载url</p>
	 *
	 * @param url  传入文件访问地址例子：web/resource/*********   如果不是web/resource开头会自动补充，或从web/resource位置开始截取
	 * @return java.lang.String
	 * @since   1.0.0
	 * @author zhk
	 * @date 2023/6/16 0016 12:37 </p>
	 */
	String getDownloadUrl(String url);

	/**
	 * <p>获取对象存储资源下载url,只补充域名,不通过通往OSS服务器获得地址</p>
	 *
	 * @param url  传入文件访问地址例子：web/resource/*********   如果不是web/resource开头会自动补充，或从web/resource位置开始截取
	 * @return java.lang.String
	 * @since   1.0.0
	 * @author zhk
	 * @date 2023/6/16 0016 12:37 </p>
	 */
	//String fillDownloadUrl(String url);
	
}
