package com.peak.prd.base.util;
/**
 * 异常，统一封装
 * @author peaktele
 *
 */

import com.peak.prd.base.model.IRespStatusEnum;
import com.peak.prd.base.model.ResponseStatusEnum;
import com.peak.prd.exception.PrdBaseException;
import java.io.PrintWriter;
import java.io.StringWriter;

public class ExceptionUtil {
	/**
	 * 处理异常，最终以ApiResult返回给前端
	 * @param responseStatusEnum 异常枚举 {@link ResponseStatusEnum} 
	 * @author wzy
	 * @CreateDate 2022年1月12日
	 *
	 */
	public static void handle(IRespStatusEnum responseStatusEnum) {
		throw new PrdBaseException(responseStatusEnum);
	}

	/**
	 * 处理异常，最终以ApiResult返回给前端，响应状态码默认10000，非特殊情况不建议使用
	 * @param code 错误编码
	 * @param msg 错误信息
	 * @author wzy
	 * @date 2023/6/14 14:50
	 */
	@Deprecated
	public static void handle(String code, String msg) {
		throw new PrdBaseException(code,msg);
	}

	/**
	 * 获得exception的调用堆栈的字符串信息
	 * @param e 例外
	 * @return exception的调用堆栈的字符串信息
	 * @author weizhenyong
	 * @date 2024/12/29 22:05
	 */
	public static String getStackTraceString(Exception e) {
		try (
				StringWriter sw = new StringWriter();
				PrintWriter pw = new PrintWriter(sw);
		) {
			e.printStackTrace(pw);

            return sw.toString();
		}
		catch (Exception e1) {
			throw new RuntimeException(e1);
		}
	}

}
