package com.peak.prd.config;

import com.peak.common.util.StringUtil;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Component;


@Component
@PropertySource(value= {"classpath:appcommon.properties"}, ignoreResourceNotFound=true)
@RefreshScope
@Getter
public class AppCommonConfig {
//	：表示当uploadfile.allowedExtensions属性不存在时，设置默认值，防止启动报错
	@Value("${uploadfile.allowedExtensions:}")
	private String uploadfileAllowedExtensions;
	
	@Value("${uploadfile.imgAllowedExtensions:.png,.jpg,.gif,.ico,.jpeg}")
	private String uploadfileImgAllowedExtensions;

	@Value("${uploadfile.zipallowedExtensions:}")
	private String uploadfileZipAllowedExtensions;
	
//	登录密码使用的加密算法，可以填写：MD5或者BCrypt，不填写默认为BCrypt
	@Value("${pwd.encode.algorithm:}")
	private String pwdEncodeAlgorithm;

	@Value("${oss.enable:0}")
	private String ossEnable;

	@Value("${lms.projectname:}")
	private String projectname;

	@Value("${notice.sender.site:}")
	private String siteNoticeSender;

	@Value("${notice.sender.email:}")
	private String emailNoticeSender;

	@Value("${notice.sender.app:}")
	private String appNoticeSender;

	@Value("${notice.sender.wechat:}")
	private String wechatNoticeSender;


	@Value("${oss.service.name:ossService}")
	private String ossServiceName;

	@ApiModelProperty("资源防盗_开关，1开启，0不开启")
	@Value("${respath.protect.enable:0}")
	private int respathProtectEnable;

	@ApiModelProperty("资源防盗_算法(大小写不敏感)，md5，sm3")
	@Value("${respath.protect.algorithm:sm3}")
	private String respathProtectAlgorithm;

	@ApiModelProperty("资源防盗_密钥")
	@Value("${respath.protect.seckey:aG@202409}")
	private String respathProtectSeckey;

	@ApiModelProperty("资源防盗_时间戳_参数名称")
	@Value("${respath.protect.timestamp.name:ts}")
	private String respathProtectTimestampName;

	@ApiModelProperty("资源防盗_时间戳_格式信息，空表示从1970年起始的毫秒，其他可以用yyyyMMddHHmmss...那样的格式定义")
	@Value("${respath.protect.timestamp.format:}")
	private String respathProtectTimestampFormat;

	@ApiModelProperty("资源防盗_签名_参数名称")
	@Value("${respath.protect.sign.name:sign}")
	private String respathProtectSignName;

	@ApiModelProperty("资源防盗_签名_格式信息")
	@Value("${respath.protect.sign.format:$seckey$timestamp$path}")
	private String respathProtectSignFormat;

	@ApiModelProperty("资源防盗_签名有效期(秒)")
	@Value("${respath.protect.validseconds:3600}")
	private int respathProtectValidseconds;

	@Value("${excel.write.columns.replace:}")
	private String excelWriteColumnsReplace;


	@Value("${uploadfile.imgExtensions:.png,.jpg,.gif,.ico,.jpeg}")
	private String uploadfileImgExtensions;

	@Value("${uploadfile.imgAllowedSizeKB:2048}")
	private Integer uploadfileImgAllowedSizeKB;

	@Value("${uploadfile.videoExtensions:.mp4,.wmv,.asf,.flv}")
	private String uploadfileVideoExtensions;

	@Value("${uploadfile.videoAllowedSizeMB:4096}")
	private Integer uploadfileVideoAllowedSizeMB;

	@Value("${uploadfile.audioExtensions:.mp3,.wma}")
	private String uploadfileAudioExtensions;

	@Value("${uploadfile.audioAllowedSizeMB:512}")
	private Integer uploadfileAudioAllowedSizeMB;


	@Value("${uploadfile.docExtensions:.doc,.docx,.xls,.xlsx,.ppt,.pptx,.pdf,.txt,.msg,.eml}")
	private String uploadfileDocExtensions;

	@Value("${uploadfile.docAllowedSizeMB:512}")
	private Integer uploadfileDocAllowedSizeMB;


	@Value("${uploadfile.zipExtensions:.zip,.rar,.7z}")
	private String uploadfileZipExtensions;

	@Value("${uploadfile.zipAllowedSizeMB:10240}")
	private Integer uploadfileZipAllowedSizeMB;

	public String getUploadfileImgExtensions() {
		return uploadfileImgExtensions;
	}

	public Integer getUploadfileImgAllowedSizeKB() {
		return uploadfileImgAllowedSizeKB;
	}

	public String getUploadfileVideoExtensions() {
		return uploadfileVideoExtensions;
	}

	public Integer getUploadfileVideoAllowedSizeMB() {
		return uploadfileVideoAllowedSizeMB;
	}

	public String getUploadfileAudioExtensions() {
		return uploadfileAudioExtensions;
	}

	public Integer getUploadfileAudioAllowedSizeMB() {
		return uploadfileAudioAllowedSizeMB;
	}

	public String getUploadfileDocExtensions() {
		return uploadfileDocExtensions;
	}

	public Integer getUploadfileDocAllowedSizeMB() {
		return uploadfileDocAllowedSizeMB;
	}

	public String getUploadfileZipExtensions() {
		return uploadfileZipExtensions;
	}

	public Integer getUploadfileZipAllowedSizeMB() {
		return uploadfileZipAllowedSizeMB;
	}





	public String getProjectname() {
		return projectname;
	}



	public boolean getOssEnable() {
		if((StringUtil.isNullorEmptyStr(ossEnable)) || ("0".equals(ossEnable))){
			return false;
		}else{
			return true;
		}
	}

	public String getOssServiceName() {
		return ossServiceName;
	}

	public String getPwdEncodeAlgorithm() {
		return pwdEncodeAlgorithm;
	}

	public String getUploadfileAllowedExtensions() {
		return uploadfileAllowedExtensions;
	}
	
	public String getUploadfileImgAllowedExtensions() {
		return uploadfileImgAllowedExtensions;
	}

	public String getSiteNoticeSender() {
		return siteNoticeSender;
	}

	public String getEmailNoticeSender() {
		return emailNoticeSender;
	}

	public String getAppNoticeSender() {
		return appNoticeSender;
	}

	public String getWechatNoticeSender() {
		return wechatNoticeSender;
	}
	
	public String getExcelWriteColumnsReplace() {
		return excelWriteColumnsReplace;
	}
}
