package com.peak.prd.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Component;


@Component
@PropertySource(value= {"classpath:lms.properties"}, ignoreResourceNotFound=true)
@RefreshScope
public class AppPathConfig {
	@Value("${lms.resource.localpath:}")
	private String resourceLocalpath;

	@Value("${lms.temp.localpath:}")
	private String tempLocalpath;

	public String getResourceLocalpath() {
		return resourceLocalpath;
	}

	public String getTempLocalpath() {

		return tempLocalpath;
	}
}
