package com.peak.prd.config;

import org.apache.commons.logging.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cache.CacheManager;
import org.springframework.cache.annotation.EnableCaching;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.data.redis.cache.RedisCacheConfiguration;
import org.springframework.data.redis.cache.RedisCacheManager;
import org.springframework.data.redis.connection.RedisConnectionFactory;

import java.time.Duration;

@Configuration
@EnableCaching
public class CacheConfig {
	private static Log logger = org.apache.commons.logging.LogFactory.getLog(CacheConfig.class);
	
////	@Value("${cache.default.expire-time}")
//    private int defaultExpireTime = 60;
////    @Value("${cache.user.expire-time}")
//    private int userCacheExpireTime;
////    @Value("${cache.user.name}")
//    private String userCacheName;
	public CacheConfig() {
		logger.warn("===============" + "CacheConfig()" + "===============");
	}
	
	/** 在application-redis.yml中配置：
	#数据缓存时间（单位秒）
	 */
	@Value("${spring.redis.peak-cacheexpiredsec:600}")
	private String redisExpiredSeconds;
	
	private boolean redisCache;
	
	/** cache底层实现是否为redis */
	public boolean isRedisCache() {
		return this.redisCache;
	}
	
	@Autowired
	RedisConfig redisConfig;

    /**
     * 缓存管理器
     */
    @Bean
    @Primary
    @ConditionalOnProperty(prefix = "spring.cache",name = "type",havingValue = "redis")
    public CacheManager cacheManager(RedisConnectionFactory redisConnectionFactory) {
		logger.info("===============" + "CacheConfig.cacheManager()" + "===============");
		logger.warn("===============" + "CacheConfig.cacheManager()" + "===============");
		
    	this.redisCache = true;
        RedisCacheConfiguration defaultCacheConfig = getCacheConfig();
        defaultCacheConfig = defaultCacheConfig.entryTtl(Duration.ofSeconds(Integer.parseInt(redisExpiredSeconds)));
//        // 设置缓存管理器管理的缓存的默认过期时间
//        defaultCacheConfig = defaultCacheConfig.entryTtl(Duration.ofSeconds(defaultExpireTime))
////                // 设置 key为string序列化
////                .serializeKeysWith(RedisSerializationContext.SerializationPair.fromSerializer(new StringRedisSerializer()))
////                // 设置value为json序列化
////                .serializeValuesWith(RedisSerializationContext.SerializationPair.fromSerializer(new GenericJackson2JsonRedisSerializer()))
////                // 不缓存空值
//                .disableCachingNullValues();
//
//        Set<String> cacheNames = new HashSet<String>();
//        cacheNames.add("prd");
//
//        // 对每个缓存空间应用不同的配置
////        Map<String, RedisCacheConfiguration> configMap = new HashMap<String, RedisCacheConfiguration>();
////        configMap.put(userCacheName, defaultCacheConfig.entryTtl(Duration.ofSeconds(userCacheExpireTime)));

//        Jackson2JsonRedisSerializer jacksonSeial = new Jackson2JsonRedisSerializer(Object.class);
//        defaultCacheConfig = defaultCacheConfig.serializeValuesWith(RedisSerializationContext.SerializationPair.fromSerializer(jacksonSeial));
        
        RedisCacheManager cacheManager = RedisCacheManager.builder(redisConnectionFactory)
                .cacheDefaults(defaultCacheConfig)
//                .initialCacheNames(cacheNames)
////                .withInitialCacheConfigurations(configMap)
                .build();
        
        return cacheManager;
    	
//    	RedisCacheManager redisCacheManager = new RedisCacheManager(redisTemplate);
//        redisCacheManager.setDefaultExpiration(3);
//        return redisCacheManager;
    }
    
    /**
     * 缓存管理器
     */
    @Bean("redisCache60")
    @ConditionalOnProperty(prefix = "spring.cache",name = "type",havingValue = "redis")
    public CacheManager redisCache60(RedisConnectionFactory redisConnectionFactory) {
    	this.redisCache = true;
    	
        RedisCacheConfiguration defaultCacheConfig = getCacheConfig();
        defaultCacheConfig = defaultCacheConfig.entryTtl(Duration.ofSeconds(60));
        RedisCacheManager cacheManager = RedisCacheManager.builder(redisConnectionFactory)
                .cacheDefaults(defaultCacheConfig)
                .build();
        return cacheManager;
    }
    
    private RedisCacheConfiguration getCacheConfig() {
    	RedisCacheConfiguration defaultCacheConfig = RedisCacheConfiguration.defaultCacheConfig();
    	String keyPrefix = redisConfig.getKeyPrefix();
    	if (keyPrefix != null) {
    		defaultCacheConfig = defaultCacheConfig.computePrefixWith((cacheName)->keyPrefix + "::" + cacheName + ":");
    	}
    	return defaultCacheConfig;
    }
    
}
