package com.peak.prd.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Configuration;

@Configuration
@RefreshScope
public class DialectConfig {
	@Value("${mybatis.config-location:}")
	private String configLocation;

	/**
	 * 数据库方言：oracle
	 */
	public boolean isOracle() {
		return configLocation != null && configLocation.indexOf("oracle") > 0;
	}

	/**
	 * 数据库方言：db2
	 */
	public boolean isDb2() {
		return configLocation != null && configLocation.indexOf("db2") > 0;
	}

	/**
	 * 数据库方言：mysql
	 */
	public boolean isMysql() {
		return configLocation != null && configLocation.indexOf("mysql") > 0;
	}

	/**
	 * 数据库方言：sqlserver
	 */
	public boolean isSqlserver() {
		return configLocation != null && configLocation.indexOf("sqlserver") > 0;
	}
	/**
	 * 是否gauss数据库
 	 * @return true：是；false：否
	 * @author wzy
	 * @date 2023/10/25 9:44
	 */
	public boolean isGauss() {
		return configLocation != null && configLocation.indexOf("gauss") > 0;
	}

	/**
	 * 是否gauss数据库
	 * @return true：是；false：否
	 * @author wzy
	 * @date 2023/10/25 9:44
	 */
	/**
	 * 是否Postgresql数据库
	 * @return boolean
	 * @author weizhenyong
	 * @date 2025/2/25 17:21
	 */
	public boolean isPostgresql() {
		return configLocation != null && configLocation.indexOf("postgresql") > 0;
	}
}
