package com.peak.prd.config;

import java.util.Date;
import java.util.UUID;

import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;

@Data
@Component
@Slf4j
public class JobConfig implements ApplicationListener<WebServerInitializedEvent> {
	private String port; // 获取当前微服务端口号 https://blog.csdn.net/justlpf/article/details/83509257
	
	private Date appstartdate; // 程序启动时间
	
	private String uuid = UUID.randomUUID().toString().replaceAll("-", "");
	
	// 代码改造，原来prd:health 改成了 prd::health 主要是因为原来hash存储object，现在改成了json
	// 如果不换key，则一些对象因为package调整 会发生反序列化错误
	public static final String HEALTH_REDIS_KEY = "prd::health"; 
	
	@Override
	public void onApplicationEvent(WebServerInitializedEvent event) {
		if (this.appstartdate == null) {
			this.appstartdate = new Date(event.getTimestamp());
			this.port = "" + event.getWebServer().getPort();
		}
		
		log.info("===jobconfig===" + this.port + " " + this.appstartdate);
	}
}
