package com.peak.prd.config;

import org.apache.commons.logging.Log;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import com.peak.common.util.IdUtil;
import com.peak.common.util.RedisService;
import com.peak.framework.key.IKey;

/**
 * 主键防冲突（分布式多机）
 * @author zhangdexin
 *
 */
@Configuration
public class PrimaryKeyConfig {
	private static Log logger = org.apache.commons.logging.LogFactory.getLog(PrimaryKeyConfig.class);
	
//	@Autowired
//	private CacheConfig cacheConfig;
	
	@Autowired
	private RedisService redisService;
	
	@Value("${spring.application.name}")
	private String application;
	
	@Value("${spring.cache.type}")
	private String cacheType;
	
	/** 服务启动后的唯一id */
	private String uuid = IdUtil.getGkey();
	
	/** 主键生成worker */
	private int workerId;
	
	@Bean
	public Object primaryKeyWorker() {
		Object foo = new Object();
		logger.info("===============cacheType:" + this.cacheType + "===============");
		boolean isRedisCache = "redis".equalsIgnoreCase(this.cacheType);
		
		if (!isRedisCache) {
			// 本功能目前只支持有redis的环境
			logger.warn("===============" + "redis:no" + "===============");
			return foo;
		}
		else {
			logger.info("===============" + "redis:yes" + "===============");
		}
		
		if (application == null || application.isEmpty()) {
			// 必须配微服务名称
			logger.warn("===============" + "application:unknown" + "===============");
			return foo;
		}
		
		String key = "primarykey:worker:all"; // + application.toLowerCase();
		long curr = redisService.increment(key, 1);
		this.workerId = (int)(curr % 32);          // 5bit
		int datacenterId = (int)(curr >> 5) % 16;  // 4bit

		IKey.DEFAULT.setConfig(datacenterId, this.workerId); // 设置workerId---雪花算法
		
		logger.info("===============" + key + "===============datacenterId:" + datacenterId + ", workerId:" + this.workerId);

		return foo;
	}
	
	/**
	 * 诊断信息
	 */
	public String getDebugInfo() {
		return "application[" + (application == null ? "unknown" : application) 
					+ "][instance:" + this.uuid + "][worker:" + this.workerId + "]";
	}

	public String getApplication() {
		return application;
	}

//	public static void main(String[] args) {
////		System.out.println(0b1111111111);
////		System.out.println((1023 & 0b1111100000) >> 5);
////		System.out.println((31 << 5) + 31);
////		System.out.println(IdUtil.getSequence("hello"));
//		long curr = 33;
//		System.out.println((int)(curr >> 32));
//		int datacenterId = (int)(curr >> 32) % 16; // 4bit
//		System.out.println(datacenterId);
//	}
}
