package com.peak.prd.exception;

import com.peak.prd.base.model.IRespStatusEnum;
import com.peak.prd.base.model.ResponseStatusEnum;

/**
 * 产品异常基类，产品的异常都要继承本类
 * @author zhangdexin
 *
 */
public class PrdBaseException extends RuntimeException {

	private static final long serialVersionUID = 1L;
	
	public PrdBaseException() {}
	
	public PrdBaseException(String msg) {
		super(msg);
		this.msg = msg;
	}
	
	public PrdBaseException(Exception ex) {
		super(ex);
		if (ex != null) {
			this.msg = ex.getMessage();
		}
	}
	
	public PrdBaseException(String msg, Exception ex) {
		super(msg, ex);
		this.msg = msg;
	}
	//异常枚举
	private IRespStatusEnum responseStatusEnum;

	//消息响应业务状态码
	private Integer status = ResponseStatusEnum.DEFAULT_BUSINESS_STATUS.getStatus();
	//错误编码
	private String code;
	//错误信息
	private String msg;

	public Integer getStatus() {
		return status;
	}

	public void setStatus(Integer status) {
		this.status = status;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public String getMsg() {
		return msg;
	}

	public void setMsg(String msg) {
		this.msg = msg;
	}

	public PrdBaseException(String code, String msg) {
		super(msg);
		this.code = code;
		this.msg = msg;
	}
//	public PrdBaseException(Integer status, String code, String msg) {
//		super(msg);
//		this.status = status;
//		this.code = code;
//		this.msg = msg;
//	}

    public PrdBaseException(IRespStatusEnum responseStatusEnum) {
        super("异常状态码为：" + responseStatusEnum.getStatus()
                + "；具体异常信息为：" + responseStatusEnum.getMsg());
        this.responseStatusEnum = responseStatusEnum;
    }

    public IRespStatusEnum getResponseStatusEnum() {
        return responseStatusEnum;
    }

    public void setResponseStatusEnum(ResponseStatusEnum responseStatusEnum) {
        this.responseStatusEnum = responseStatusEnum;
    }

}
