package com.peak.prd.quartz.health;

import java.io.Serializable;
import java.text.SimpleDateFormat;

import com.fasterxml.jackson.annotation.JsonIgnore;

import lombok.Data;

/**
 * 服务运行健康状态
 * @author zhangdexin
 *
 */
@Data
public class Health implements Serializable {
	private static final long serialVersionUID = 1L;
	
	private String uuid;     // 服务实例 - 每次启动变化 ，启动后唯一不变
	private String ip;       // 服务所在机器ip
	private String port;     // 服务的端口号（没用int，因为发现在云环境，用int有些问题）
	private long activeDate; // 心跳时间
	
	public Health() {}
	
	public Health(String uuid, String ip, String port, long activeDate) {
		this.uuid = uuid;
		this.ip = ip;
		this.port = port;
		this.activeDate = activeDate;
	}
	
	/** n秒前 - 方便人类读取服务活跃与否 */
	@JsonIgnore
	public String getHumanActiveDateString() {
		return (System.currentTimeMillis() - activeDate) / 1000 + "秒前";
	}
	
	public String getActiveDateString() {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
		return sdf.format(new java.util.Date(this.activeDate));
	}
}
