package com.peak.prd.quartz.health;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import com.alibaba.fastjson.JSON;
import com.peak.common.util.RedisHashService;
import com.peak.common.util.RedisObjectService;
import com.peak.common.util.SpringUtil;
import com.peak.prd.config.JobConfig;

import lombok.extern.slf4j.Slf4j;

@Slf4j
public class HealthHelper {
//	private static boolean inited = false;
//	
//	/**
//	 * 初始化 只在服务启动后调用1次
//	 * @throws UnknownHostException
//	 */
//	public static void initHealth() throws UnknownHostException {
//		if (!inited) {
//			log.info("初始化心跳");
//			health();
//			inited = true;
//		}
//	}
	
	/**
	 * 健康、心跳通知
	 * @throws UnknownHostException
	 */
	public static void health() throws UnknownHostException {
		JobConfig jobConfig = SpringUtil.getBean(JobConfig.class);
		RedisHashService redisHashService = SpringUtil.getBean(RedisHashService.class);
		
		String ip = InetAddress.getLocalHost().getHostAddress();
		Health h = new Health(jobConfig.getUuid(), ip, jobConfig.getPort(), System.currentTimeMillis());
		
		// uuid是运行唯一id，每次启动会变化，启动后不变
		// redis中有1个hash
		// hash里的key是服务运行id
		// hash里的value是服务健康状态描述
		redisHashService.put(JobConfig.HEALTH_REDIS_KEY, jobConfig.getUuid(), JSON.toJSONString(h));
	}
	
	/**
	 * 获取所有服务实例的健康情况
	 * @return
	 */
	public static List<Health> getHealths() {
		RedisObjectService redisObjectService = SpringUtil.getBean(RedisObjectService.class);
		Set<Object> hashKeys = redisObjectService.getHashKeys(JobConfig.HEALTH_REDIS_KEY);
		
		RedisHashService redisHashService = SpringUtil.getBean(RedisHashService.class);
		List<Health> healths = new ArrayList<Health>();
		
		if (hashKeys != null) {
			Iterator<Object> iter = hashKeys.iterator();
			while (iter.hasNext()) {
				String hashKey = (String)iter.next();
				String hashVal = (String)redisHashService.get(JobConfig.HEALTH_REDIS_KEY, hashKey);
				Health health = JSON.parseObject(hashVal, Health.class);
				
				healths.add(health);
			}
		}
		
		return healths;
	}
	
	/**
	 * 清理redis中的死亡服务数据 - 死亡服务（即长久没心跳的服务）
	 */
	public static void clearDeads() {
		RedisObjectService redisObjectService = (RedisObjectService)SpringUtil.getBean(RedisObjectService.class);
		
		List<Health> healths = getHealths();
		for (Health h : healths) {
			if (h == null) {
				continue;
			}
			
			long pastms = System.currentTimeMillis() - h.getActiveDate();
			if (pastms >= 60000 * 5) { // 暂定5分钟没有心跳就算dead
				redisObjectService.delHash(JobConfig.HEALTH_REDIS_KEY, h.getUuid());
				log.info("clear dead job service in redis: " 
						+ h.getUuid()
						+ ", " + h.getIp()
						+ ", " + h.getPort()
						+ ", " + new Date(h.getActiveDate()));
			}
		}
	}
}
