package com.peak.prd.quartz.health;

import java.net.UnknownHostException;

import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import com.peak.prd.quartz.INoLockJob;

/**
 * 心跳任务（工程可能会有多机多实例）<br />
 *
 * @author zhangdexin
 *
 */
@Component
public class HealthJob implements INoLockJob { // 心跳服务 不要加锁
	
	/**
	 * 每隔30秒 心跳1次
	 * @throws UnknownHostException
	 * @throws InterruptedException
	 */
	@Scheduled(cron = "30 * * * * ?")
    public void run() throws UnknownHostException, InterruptedException {
		HealthHelper.health();     // 心跳
		
		HealthHelper.clearDeads(); // 清理redis中的垃圾服务
    }
	
}
