package com.peak.security.aes;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.Security;
import java.security.spec.KeySpec;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import javax.crypto.Cipher;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
 /**
  * JS iso android java 加密开发
  * @author zhao
  *
  */
public class AECoder
{
    private static final  String DEFAULT_IV = "91a90d6aa4241465";
    private static final  String ENCODING="UTF-8";
   // private static final  String CIPHER_ALGORITHM="AES/CBC/PKCS5Padding";
    private static final  String CIPHER_ALGORITHM="AES/CBC/PKCS7Padding";

    private Key secretKey;
    private IvParameterSpec ivParameterSpec;
    private int keySize=128;
    private Cipher cipher; 
    static {
    	Security.addProvider(new BouncyCastleProvider());
    	  
    }
    public static AECoder getInstance(String secretKey)
    {
        return new AECoder(secretKey,DEFAULT_IV);
    }
    public static AECoder getInstance(String secretKey,String iv)
    {
        return new AECoder(secretKey,iv);
    }
    private byte[] getKey(String keyStr) throws UnsupportedEncodingException{
    	int workLength=keySize/8;
    	StringBuffer keyBuffer=new StringBuffer();
    	for(int i=0;i<workLength;i++){
    	    int y=i%keyStr.length();
    	    keyBuffer.append(keyStr.charAt(y));
    	}
    	return keyBuffer.toString().getBytes("UTF-8");
    }
    private AECoder(String key,String iv) {
        try {
        	byte[] keyByte=getKey(key);
            secretKey = new SecretKeySpec(keyByte, "AES");
            ivParameterSpec=new IvParameterSpec(iv.getBytes(ENCODING));
          	 cipher = Cipher.getInstance(CIPHER_ALGORITHM, "BC");
            //   cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        } catch (Exception e){
            throw new RuntimeException("AES Crypto is not supported by System. " + e.getMessage());
        }
    }
    
    public String createKey(String passphrase, String salt, int keySize, int iterationCount) {
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            KeySpec spec = new PBEKeySpec(passphrase.toCharArray(), hex(salt), iterationCount, keySize);
            return new String(factory.generateSecret(spec).getEncoded(),"UTF-8");
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
    private static byte[] hex(String str) {
        try {
            return Hex.decodeHex(str.toCharArray());
        }
        catch (DecoderException e) {
            throw new IllegalStateException(e);
        }
    }
    /**
     * Encrypt the data
     * @param tobeEncrypted
     * @return
     */
    public String encrypt(String tobeEncrypted)
    {
        try {
            cipher.init(Cipher.ENCRYPT_MODE, secretKey, ivParameterSpec);
            byte[] result = cipher.doFinal(tobeEncrypted.getBytes(ENCODING));
            String encrypted =new String(Base64.encodeBase64(result),ENCODING);
            return encrypted;
        } catch (Exception e) {
            throw new RuntimeException("Encrypt using AES failed. " + e.getMessage());
        }
    }
   
    /**
     * Decrypt the data
     * @param encrypted
     * @return
     */
    public String decrypt(String encrypted){
        try {
      
            cipher.init(Cipher.DECRYPT_MODE, secretKey,ivParameterSpec);
            byte[] decodes = Base64.decodeBase64(encrypted.getBytes(ENCODING));
            return new String(cipher.doFinal(decodes),ENCODING);
        } catch (Exception e) {
            throw new RuntimeException("Deecrypt using AES failed. " + e.getMessage());
        }
    }
    public static void main(String[] args) throws Exception{
    	

        
        ExecutorService fixedThreadPool = Executors.newFixedThreadPool(10); 
        final long time =System.currentTimeMillis();
        for (int i = 0; i <= 100000; i++) {  
         final int index = i;  
         fixedThreadPool.execute(new Runnable() {  
          public void run() {  
           try {  
               AECoder cryptor =AECoder.getInstance("AESCODER20151010");
               String encrypted = cryptor.encrypt("赵123456fdsafdsafffffdsfsdffffffffffrewrwerewwwwwwwwrwerwerwffffffffffffwerwer");
               String decrypt=cryptor.decrypt(encrypted);

               if(index==100000){
            	   long time2=(System.currentTimeMillis()-time)/1000;
               }
           } catch (Exception e) {  
              e.printStackTrace();  
           }  
          }  
         });  
        }  
        fixedThreadPool.shutdown();
       } 
}
