package com.peak.security.aes;

import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;

import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import java.security.Key;
import java.security.spec.KeySpec;

/**
 * Utility class for encrypt or decrypt with AES encryption.
 * 可配置客户端加密解密的工具
 * @see #encrypt(String)
 * @see #decrypt(String)
 */
public class AESCoder2 {

    private static final  int DEFAULT_KEY_SIZE = 128;
    private static final  int DEFAULT_ITERATION_COUNT =9;
	private static final String KEY_ALGORITHM = "AES";
    private static final  String CIPHER_ALGORITHM="AES/CBC/PKCS5Padding";
    
    
    private static final  String DEFAULT_PASS = "R1E9D8F0I0R6E88";
    private static final  String DEFAULT_SALT = "72216a6607a2a2d8939d5a324b195ba32bab81cd";
    private static final  String DEFAULT_IV ="91a90d6aa4241465fb2ac9ab0e06eba0";

    private final IvParameterSpec ivParameterSpec;
    private final Key key;

    /**
     * Initialize an instance of AesHelper with given encryption parameters
     * @param passphrase The passphrase
     * @param salt A hexadecimal String with an even number of characters
     * @param iv Initialization vector. A hexadecimal String of 16 bytes length (i.e 32 characters length)
     */
    public AESCoder2() {
        this(DEFAULT_PASS, DEFAULT_SALT, DEFAULT_IV, DEFAULT_KEY_SIZE, DEFAULT_ITERATION_COUNT);
    }
    public AESCoder2(String passphrase) {
        this(passphrase, DEFAULT_SALT, DEFAULT_IV, DEFAULT_KEY_SIZE, DEFAULT_ITERATION_COUNT);
    }
    public AESCoder2(String passphrase, String salt, String iv) {
        this(passphrase, salt, iv, DEFAULT_KEY_SIZE, DEFAULT_ITERATION_COUNT);
    }

    /**
     * Initialize an instance of AesHelper with given encryption parameters
     * @param passphrase The passphrase
     * @param salt A hexadecimal String with an even number of characters
     * @param iv Initialization vector. A hexadecimal String of 16 bytes length (i.e 32 characters length)
     * @param keySize Size of AES key (128, 196, 256).
     * @param iterationCount Iteration count used for key generation.
     */
    public AESCoder2(String passphrase, String salt, String iv, int keySize, int iterationCount) {
        this.key = generateKey(passphrase, salt, keySize, iterationCount);
        this.ivParameterSpec = new IvParameterSpec(hex(iv));
    }

    private SecretKey generateKey(String passphrase, String salt, int keySize, int iterationCount) {
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            KeySpec spec = new PBEKeySpec(passphrase.toCharArray(), hex(salt), iterationCount, keySize);
            return new SecretKeySpec(factory.generateSecret(spec).getEncoded(), KEY_ALGORITHM);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * Encrypt text with AES encryption
     * @param plaintext text to encrypt
     */
    public String encrypt(String plaintext) {
        try {
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
            cipher.init(Cipher.ENCRYPT_MODE, this.key, this.ivParameterSpec);
            byte[] encrypted =  cipher.doFinal(plaintext.getBytes("UTF-8"));
            return base64(encrypted);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * Decrypt text with AES encryption
     * @param ciphertext encrypted text
     */
    public String decrypt(String ciphertext) {
        try {
            Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
            cipher.init(Cipher.DECRYPT_MODE, this.key, this.ivParameterSpec);
            byte[] decrypted = cipher.doFinal(base64(ciphertext));
            return new String(decrypted, "UTF-8");
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String base64(byte[] bytes) throws Exception {
        return new String( Base64.encodeBase64(bytes),"UTF8");
    }

    private static byte[] base64(String str) throws Exception {
        return Base64.decodeBase64(str.getBytes("UTF8"));
    }

    private static byte[] hex(String str) {
        try {
            return Hex.decodeHex(str.toCharArray());
        }
        catch (DecoderException e) {
            throw new IllegalStateException(e);
        }
    }
    public static void main(String[] args){
    	// Encryption parameters
//         String PASSPHRASE = "redfire_2015";
//         String PLAIN_TEXT = "赵1234324";
//         AESCoder2 aesHelper = new AESCoder2(PASSPHRASE,DEFAULT_SALT,DEFAULT_IV);
//         System.out.println("密钥:"+new String(Hex.encodeHex(aesHelper.key.getEncoded())));
//         System.out.println("明文:"+PLAIN_TEXT);
//         String encrypt = aesHelper.encrypt(PLAIN_TEXT);
//         System.out.println("密文:"+encrypt);
//         String ha="GQgmYaXD6Wq1Aq/Bq3ZL/Q==";
//         String decrypt = aesHelper.decrypt(encrypt);
//         System.out.println("解密后:"+decrypt);
   
    }
}