/**
 * 2009-5-20
 */
package com.peak.security.rsa;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.binary.StringUtils;

import javax.crypto.Cipher;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;

/**
 * 证书组件
 * 
 * @author 赵国栋
 * @version 1.0
 */
public class RSAClient {

	/**
	 * 类型证书X509
	 */
	public static final String CERT_TYPE = "X.509";
	
	private static final String ALGORITHM=	"RSA/ECB/PKCS1Padding";
	private  Certificate clientCertificate=null;

    private  RSAClient(){
    	
    }
	/**
	 * 获得ClientX509
	 * 
	 * @param classOrFilePath 
	 *            证书路径 类路径 或者文件路径
	 * @return ClientX509 证书 错误返回空
	 */
    public static RSAClient  getInstance()  
	{  
	  String certificatePath = "client/peak_service.cer";
	   return RSAClient.getInstance(certificatePath);
	} 
	public static RSAClient  getInstance(String classOrFilePath) {
		if(classOrFilePath==null ) return  null;
		InputStream in=null;
		 // 实例化证书工厂
		 try {
		    File certFile=new File(classOrFilePath);
			if(!certFile.exists()){
				 in=Thread.currentThread().getContextClassLoader().getResourceAsStream(classOrFilePath);
			}else{
				 in = new FileInputStream(certFile);
			}
		    if(in!=null){
			      RSAClient client=new RSAClient();
				  CertificateFactory certificateFactory = CertificateFactory.getInstance(CERT_TYPE);
				  client.clientCertificate =certificateFactory.generateCertificate(in);
				  return client;
			}
				
		  } catch (Exception e) {
			    e.printStackTrace();
		  }finally{
			  if(in!=null){
				  try {
					in.close();
				  } catch (IOException e) {
					e.printStackTrace();
				 }
			  }
		   }
		   return null;
	}
	/**
	 * 由Certificate获得公钥
	 * 
	 * @param certificatePath
	 *            证书路径
	 * @return PublicKey 公钥
	 * @throws Exception
	 */
	public  PublicKey getPublicKey()  {
		// 获得公钥
		return this.clientCertificate.getPublicKey();

	}


	/**
	 * 公钥加密
	 * @param data 待加密数据
	 * @return byte[] 加密数据
	 * @throws Exception
	 */
	public  byte[] encrypt(byte[] data)  throws Exception {

		// 取得公钥
		PublicKey publicKey = this.getPublicKey();

		// 对数据加密
		//System.out.println("公钥加密算法："+publicKey.getAlgorithm());
		//Cipher cipher = Cipher.getInstance(publicKey.getAlgorithm());
		//"RSA/ECB/PKCS1Padding"
		Cipher cipher = Cipher.getInstance(ALGORITHM);
		cipher.init(Cipher.ENCRYPT_MODE, publicKey);

		return cipher.doFinal(data);

	}
	/**
	 * 公钥加密 
	 * @param data 待加密数据 ,会通过 getByte("UTF8")方式获取编码
	 * @return string 返回Base64编码不换行,UTF8 编码方式的字符串
	 * @throws Exception
	 */
	public  String encrypt(String data)  throws Exception {
		byte[] dataByte =StringUtils.getBytesUtf8(data);
		
	    byte[] encryptByte=this.encrypt(dataByte);
	    
		String returnValue=StringUtils.newStringUtf8(Base64.encodeBase64(encryptByte, false));
		return returnValue;

	}
	/**
	 * 公钥解密
	 * 
	 * @param data
	 *            待解密数据
	 * @return byte[] 解密数据
	 * @throws Exception
	 */
	public  byte[] decrypt(byte[] data)throws Exception {

		// 取得公钥
		PublicKey publicKey = this.getPublicKey();

		// 对数据加密
		//Cipher cipher = Cipher.getInstance(publicKey.getAlgorithm());
		Cipher cipher = Cipher.getInstance(ALGORITHM);
		cipher.init(Cipher.DECRYPT_MODE, publicKey);

		return cipher.doFinal(data);

	}
	/**
	 * 公钥解密
	 * @param data 待解密数据,获取UTF8编码字节，再进行Base64解码
	 * @return string 揭秘后的字符窜
	 * @throws Exception
	 */
	public  String decrypt(String data)  throws Exception {
		byte[] dataByte=StringUtils.getBytesUtf8(data);
	    byte[] encryptByte= Base64.decodeBase64(dataByte);
	    
		byte[] decryptByte =this.decrypt(encryptByte);

		String returnValue=StringUtils.newStringUtf8(decryptByte);
		return returnValue;

	}
	/**
	 * 公钥验证签名 验证签名
	 * @param data
           数据
	 * @param sign
	 *            签名
	 * @return boolean 验证通过为真
	 * @throws Exception
	 */
	public  boolean verify(byte[] data, byte[] sign) throws Exception {

		// 获得证书
		X509Certificate x509Certificate = (X509Certificate)this.clientCertificate;
		// 由证书构建签名
		Signature signature = Signature.getInstance(x509Certificate.getSigAlgName());
		// 由证书初始化签名，实际上是使用了证书中的公钥
		signature.initVerify(x509Certificate);
		signature.update(data);
		return signature.verify(sign);
	}

    public  boolean verify(String data,String sign)  throws Exception {
    	byte[] dataByte =StringUtils.getBytesUtf8(data);
	    byte[] signByte= Hex.decodeHex(sign.toCharArray());
		return this.verify(dataByte, signByte);
	}
}
