/**
 * 2009-5-20
 */
package com.peak.security.rsa;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.binary.StringUtils;

import javax.crypto.Cipher;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;


/**
 * 服务器端证书加密
 * 
 * @author zgd 2015-10-30
 * @version 1.0
 */
public class RSAService {

	/**
	 * 类型证书X509
	 */
	public static final String STORE_TYPE = "jks";
	private static final String ALGORITHM=	"RSA/ECB/PKCS1Padding";
    private PrivateKey privateKey=null;
	private Certificate servicCertificate=null;

    private RSAService(){}

	/**
	 * 获得ServiceCert 服务器加密对象
	 * 你需要缓存本地对象重复使用
	 * 
	 * @param classOrFilePath
	 *            密钥库路径
	 * @param alias
	 *            别名
	 * @param storePwd
	 *            库密码
	 * @param keyPwd  私钥密码
	 * return  出错返回 null 
	 */
    public static RSAService  getInstance()  
	{  
    	     String storePwd = "12345678";
			 String keyPwd = "12345678";
			 String alias = "www.peaktele.com";
			 String keyStorePath = "service/peak_service.jks";
		     return RSAService.getInstance(keyStorePath, alias, storePwd, keyPwd) ;
	} 
	public static RSAService  getInstance(String classOrFilePath,String alias,String storePwd,String keyPwd) {
		if(classOrFilePath==null) return  null;
		 InputStream in=null;
		 try {
			    File certFile=new File(classOrFilePath);
				if(!certFile.exists()){
					 in=Thread.currentThread().getContextClassLoader().getResourceAsStream(classOrFilePath);
				}else{
					 in = new FileInputStream(certFile);
				}
			    if(in!=null){
			    	  RSAService serviceCert=new RSAService();
				      KeyStore ks = KeyStore.getInstance(STORE_TYPE);
					  ks.load(in, storePwd.toCharArray());
					  //获取私有key
					  serviceCert.privateKey= (PrivateKey)ks.getKey(alias, keyPwd.toCharArray());
					  // 获得证书
					  serviceCert.servicCertificate= ks.getCertificate(alias);
					  return serviceCert;
				}
					
			  } catch (Exception e) {
				    e.printStackTrace();
			  }finally{
				  if(in!=null){
					  try {
						in.close();
					  } catch (IOException e) {
						e.printStackTrace();
					 }
				  }
		 }
	

		return null;
	}


	/**
	 * 私钥加密
	 * @param data
	 *            待加密数据
	 * @return byte[] 加密数据
	 * @throws Exception
	 */
	public  byte[] encrypt(byte[] data) throws Exception {
		// 对数据加密
		Cipher cipher = Cipher.getInstance(ALGORITHM);
		//Cipher cipher = Cipher.getInstance(privateKey.getAlgorithm());
		cipher.init(Cipher.ENCRYPT_MODE, privateKey);

		return cipher.doFinal(data);

	}
	/**
	 * 私钥加密 
	 * @param data 待加密数据 ,会通过 getByte("UTF8")方式获取编码
	 * @return string 返回Base64编码不换行,UTF8 编码方式的字符串
	 * @throws Exception
	 */
	public  String encrypt(String data)  throws Exception {
		byte[] dataByte =StringUtils.getBytesUtf8(data);
		
	    byte[] encryptByte=this.encrypt(dataByte);
	    
		String returnValue=StringUtils.newStringUtf8(Base64.encodeBase64(encryptByte, false));
		return returnValue;

	}
	/**
	 * 私钥解密
	 * 
	 * @param data
	 *            待解密数据
	 * @return byte[] 
	 * 				解密数据
	 * @throws Exception
	 */
	public  byte[] decrypt(byte[] data) throws Exception {
		// 对数据加密
		Cipher cipher = Cipher.getInstance(ALGORITHM);
		//Cipher cipher = Cipher.getInstance(privateKey.getAlgorithm());
		cipher.init(Cipher.DECRYPT_MODE, privateKey);
		return cipher.doFinal(data);

	}
	/**
	 * 公钥解密
	 * @param data 待解密数据,获取UTF8编码字节，再进行Base64解码
	 * @return string 揭秘后的字符窜
	 * @throws Exception
	 */
	public  String decrypt(String data)  throws Exception {
		byte[] dataByte=StringUtils.getBytesUtf8(data);
	    byte[] encryptByte= Base64.decodeBase64(dataByte);
	    
		byte[] decryptByte =this.decrypt(encryptByte);

		String returnValue=StringUtils.newStringUtf8(decryptByte);
		return returnValue;

	}
	/**
	 * 私钥签名签名
	 * @return byte[] 签名
	 * @throws Exception
	 */
	public  byte[] sign(byte[] data) throws Exception {
		// 获得证书
		X509Certificate x509Certificate = (X509Certificate) this.servicCertificate;
		// 构建签名，由证书指定签名算法
		Signature signature = Signature.getInstance(x509Certificate.getSigAlgName());
		// 初始化签名，由私钥构建
		signature.initSign(this.privateKey);

		signature.update(data);

		return signature.sign();
	}

   public  String sign(String data)  throws Exception {
	    	byte[] dataByte =StringUtils.getBytesUtf8(data);
	    	
	    	
		    byte[] signByte= this.sign(dataByte);
		    
			return Hex.encodeHexString(signByte);

	}

   PrivateKey getPrivateKey() {
	return privateKey;
   }

}
