package com.peak.tools.easyexcel.converter;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.data.ReadCellData;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import java.util.Objects;

public class IdentitysConverter implements Converter<Long> {
	
	private static final String PARTY_MEMBER = "中共党员";
    private static final String PROBATIONARY_PARTY_MEMBER = "中共预备党员";
    private static final String LEAGUE_MEMBER = "共青团员";
    private static final String NON_PARTY = "群众";
    private static final String OTHER = "其他";
	
    // Java数据类型 integer
    @Override
    public Class supportJavaTypeKey() {
        return Long.class;
    }

    // Excel文件中单元格的数据类型  string
    @Override
    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    // 读取Excel文件时将string转换为integer
    @Override
    public Long convertToJavaData(ReadCellData cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration)
       throws Exception {
        String value = cellData.getStringValue();
        if (Objects.equals(PARTY_MEMBER, value)) {
            return 1011L;
        } else if (Objects.equals(PROBATIONARY_PARTY_MEMBER, value)) {
            return 1021L;
        } else if (Objects.equals(LEAGUE_MEMBER, value)) {
            return 1031L;
        } else if (Objects.equals(NON_PARTY, value)) {
            return 1041L;
        }
        return 1051L; // 0-不明
    }

    // 写入Excel文件时将integer转换为string
    @Override
    public WriteCellData convertToExcelData(Long value, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        if(value == null) {
            return new WriteCellData("");
        }
        if (value.intValue() == 1011L) {
            return new WriteCellData(PARTY_MEMBER);
        } else if (value.intValue() == 1021L) {
            return new WriteCellData(PROBATIONARY_PARTY_MEMBER);
        } else if (value.intValue() == 1031L) {
            return new WriteCellData(LEAGUE_MEMBER);
        } else if (value.intValue() == 1041L) {
            return new WriteCellData(NON_PARTY);
        }
        return new WriteCellData(OTHER); // 不明
    }
    
}
