package com.peak.tools.easyexcel.converter;

import java.util.Objects;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.data.ReadCellData;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.metadata.property.ExcelContentProperty;

/**
 * 
 * <p>报到状态字段的数据转换器</p>
 * @author ldc
 * @version 1.0
 * @date 2022-10-21 14:50:43
 *
 */
public class RegisterStatusConverter implements Converter<Integer> {
	
	private static final String NOTREGISTER_STATUS = "未报到";
    private static final String TREGISTER_STATUS = "已报到";

	
	 // Java数据类型 integer
    @Override
    public Class supportJavaTypeKey() {
        return Integer.class;
    }

    // Excel文件中单元格的数据类型  string
    @Override
    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    // 读取Excel文件时将string转换为integer
    @Override
    public Integer convertToJavaData(ReadCellData cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) 
       throws Exception {
        String value = cellData.getStringValue();
        if (Objects.equals(NOTREGISTER_STATUS, value)) {
            return 0; // 0-未报到
        } else if (Objects.equals(TREGISTER_STATUS, value)) {
            return 1; // 1-已报到
        }
        return 0; // 0-未报到
    }

    // 写入Excel文件时将integer转换为string
    @Override
    public WriteCellData convertToExcelData(Integer value, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        if(value == null) {
            return new WriteCellData("");
        }
        if(value != null) {
        	if (value.intValue() == 0) {
	            return new WriteCellData(NOTREGISTER_STATUS);
	        } else if (value.intValue() == 1) {
	            return new WriteCellData(TREGISTER_STATUS);
	        } 
        }
        return new WriteCellData(NOTREGISTER_STATUS); // 未报到
    }
	
}
