package com.peak.tools.easyexcel.converter;

import java.util.Objects;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.data.ReadCellData;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.metadata.property.ExcelContentProperty;

public class SexStatusConverter implements Converter<Integer> {
	
	private static final String SEX_MAN = "男";
    private static final String SEX_WOMAN = "女";
    private static final String SEX_OTHER = "不明";
	
    // Java数据类型 integer
    @Override
    public Class supportJavaTypeKey() {
        return Integer.class;
    }

    // Excel文件中单元格的数据类型  string
    @Override
    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    // 读取Excel文件时将string转换为integer
    @Override
    public Integer convertToJavaData(ReadCellData cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) 
       throws Exception {
        String value = cellData.getStringValue();
        if (Objects.equals(SEX_MAN, value)) {
            return 1; // 1-男
        } else if (Objects.equals(SEX_WOMAN, value)) {
            return 2; // 2-女
        }
        return 0; // 0-不明
    }

    // 写入Excel文件时将integer转换为string
    @Override
    public WriteCellData convertToExcelData(Integer value, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        if(value == null) {
            return new WriteCellData("");
        }
        if (value.intValue() == 1) {
            return new WriteCellData(SEX_MAN);
        } else if (value.intValue() == 2) {
            return new WriteCellData(SEX_WOMAN);
        }
        return new WriteCellData(SEX_OTHER); // 不明
    }
    
}
