package com.peak.tools.easyexcel.converter;

import com.alibaba.excel.converters.NullableObjectConverter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.data.ReadCellData;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.metadata.property.ExcelContentProperty;

import java.util.Objects;

public class StatusGetConverter implements NullableObjectConverter<Integer> {
	
	private static final String PASSED = "已获得";
    private static final String NOPASSED = "未获得";
    
 // Java数据类型 integer
    @Override
    public Class supportJavaTypeKey() {
        return Integer.class;
    }
    
 // Excel文件中单元格的数据类型  string
    @Override
    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }
    
 // 读取Excel文件时将string转换为integer
    @Override
    public Integer convertToJavaData(ReadCellData cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) 
       throws Exception {
        String value = cellData.getStringValue();
        if (Objects.equals(NOPASSED, value)) {
            return 0; 
        } else if (Objects.equals(PASSED, value)) {
            return 1; 
        }
        return 0; 
    }

    // 写入Excel文件时将integer转换为string
    @Override
    public WriteCellData convertToExcelData(Integer value, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        if(value == null) {
            return new WriteCellData("");
        }

        if (value.intValue() == 1) {
            return new WriteCellData(PASSED);
        } else if (value.intValue() == 0) {
            return new WriteCellData(NOPASSED);
        }
        return new WriteCellData(NOPASSED); 
    }
}
