package com.peak.tools.easyexcel.data;

import com.peak.tools.easyexcel.model.BaseExcelModel;
import com.peak.tools.easyexcel.model.ExcelModelData;

import java.util.List;

/**
 * <p>Excel导出数据工具接口</p>
 * @author ldc
 * @date 2025/1/20 13:03
*/
public abstract class ExcelWriteBusinessDataUtil {

    /**
     * <p>获得导出数据接口，需要调用方实现具体业务</p>
     * @param pageNumber            页数
     * @param pageSize              每页数据，默认1000
     * @return com.peak.tools.easyexcel.model.ExcelModelData<? extends com.peak.tools.easyexcel.model.BaseExcelModel>
     * @author ldc
     * @date 2025/1/20 13:04
    */
    public abstract ExcelModelData<? extends BaseExcelModel> getExcelModelDataMap(int pageNumber, int pageSize);

    /**
     * <p>获得错误的导出数据</p>
     * @param e                        异常
     * @return com.peak.tools.easyexcel.model.ExcelModelData<? extends com.peak.tools.easyexcel.model.BaseExcelModel>
     * @author ldc
     * @date 2025/1/20 13:45
    */
    public abstract <Model extends BaseExcelModel> Model getExcelErrorModelDataMap(Exception e);


    /**
     * <p>获得隐藏列方法，返回值应该是隐藏列数组，不需要有隐藏列可以返回null</p>
     * @return java.util.List<java.lang.String>
     * @author ldc
     * @date 2025/1/20 13:30
    */
    public abstract List<String> getHideColumnList();

}
