package com.peak.tools.easyexcel.model;

import java.util.ArrayList;
import java.util.List;

import com.alibaba.excel.exception.ExcelAnalysisStopException;

/**
 * 
 * <p>excel读取后实体数据对象,在Listener中使用后会获得到读取信息</p>
 * @author ldc
 * @version 1.0
 * @date 2022-5-12 15:29:30
 *
 * @param <T>
 */
public class ExcelReadData<T> {
	
	//连续为空行数
	private int serialNullRows = 0;
	
	//最大允许连续为空行数为10行
	private static final int MAX_SERIALNULLROWS = 10;
	
	/**excel数据列表*/
	private List<T> dataList = new ArrayList<T>();
	
	/**excel错误信息数据对象列表*/
	private List<ReadErrorData> errorList = new ArrayList<ReadErrorData>();

	public List<T> getDataList() {
		return dataList;
	}

	public List<ReadErrorData> getErrorList() {
		return errorList;
	}
	
	/**
	 * <p>增加导入错误信息对象</p>
	 * @param errorDate			错误对象列表
	 * @param rowIndex			错误发生行索引
	 * @author ldc
	 * @version 1.0
	 * @date 2022-5-12 16:01:22
	 */
	public void addReadErrorData(List<Object> errorData, int rowIndex) {
		ReadErrorData readErrorData = new ReadErrorData(errorData, rowIndex);
		this.errorList.add(readErrorData);
	}
	
	/**
	 * <p>增加导入错误信息对象</p>
	 * @param errorDate			错误对象
	 * @param rowIndex			错误发生行索引
	 * @author ldc
	 * @version 1.0
	 * @date 2022-5-12 16:01:22
	 */
	public void addReadErrorData(Object errorData, int rowIndex) {
		ReadErrorData readErrorData = new ReadErrorData(errorData, rowIndex);
		this.errorList.add(readErrorData);
	}

	public int getSerialNullRows() {
		return serialNullRows;
	}

	public void setSerialNullRows(int serialNullRows) {
		this.serialNullRows = serialNullRows;
	}
	
	public void addSerialNullRows() {
		if(serialNullRows < MAX_SERIALNULLROWS) {
			this.serialNullRows ++;
		} else {
			throw new ExcelAnalysisStopException();
		}
	}
	
}
