package com.peak.tools.easyexcel.model;

import java.io.Serializable;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;


@ApiModel("ExcelResulVO")
public class ExcelResultVO implements Serializable {

	private static final long serialVersionUID = 2471711103773103071L;
	
	@ApiModelProperty("读取总数量")
	private Integer readTotalNum;
	
	@ApiModelProperty("读取成功数量")
	private Integer readSuccessNum;
	
	@ApiModelProperty("读取错误数量")
	private Integer readErrorNum;
	
	@ApiModelProperty("错误数据excel路径")
	private String errorExcelFilepath;

	public Integer getReadTotalNum() {
		return readTotalNum;
	}

	public void setReadTotalNum(Integer readTotalNum) {
		this.readTotalNum = readTotalNum;
	}

	public Integer getReadSuccessNum() {
		return readSuccessNum;
	}

	public void setReadSuccessNum(Integer readSuccessNum) {
		this.readSuccessNum = readSuccessNum;
	}

	public Integer getReadErrorNum() {
		return readErrorNum;
	}

	public void setReadErrorNum(Integer readErrorNum) {
		this.readErrorNum = readErrorNum;
	}

	/**
	 * <p>相对resource目录全路径，示例：errorexcelpath/2021/08/20/ae37d4bd-3095-4edb-9798-5db52d85da34.xlsx</p>
	 * @return
	 * @author ldc
	 * @version 1.0
	 * @date 2022-5-16 14:03:45
	 */
	public String getErrorExcelFilepath() {
		return errorExcelFilepath;
	}

	public void setErrorExcelFilepath(String errorExcelFilepath) {
		this.errorExcelFilepath = errorExcelFilepath;
	}
}
